/**
 * 
 */

/**
 * Klasse Queue zur Umsetzung des ADT Schlange entsprechend der Vorgaben
 * des KC Informatik für die gymnasiale Oberstufe in Niedersachsen
 * @author Landesnetzwerk Informatik Niedersachsen, Carsten Rohe
 * @version 0.8_20200429
 * Inhaltstyp wurde von Annika Eickhoff-Schachtebeck für infsii-Material für Beispiel angepasst auf Integer
 */
public class ZahlQueue
{
  private int length;
  private Element head;

  /**
   * Eine leere Schlange wird angelegt.
   */
  public ZahlQueue()
  {
    length = 0;
    head = null;
  }   
  
  /**
   * Es wird geprüft, ob die Schlange leer ist.
   * @return Wenn die Schlange kein Element enthält, wird der Wert true zurückgegeben, sonst der Wert false.
   */
  public boolean isEmpty()
  {
    if (length==0)
      return true;
    //else 
    return false;
  }
  
  /**
   * Der Inhalt des ersten Elements der Schlange wird ausgelesen.
   * Das Element wird dabei aber nicht aus der Schlange entfernt.
   * @return Der Inhalt des ersten Elements der Schlange.
   */
  public int head()
  {
    //if (!isEmpty())   //  Laufzeitfehler müssen laut Vorgaben bei der Anwendung der Operationen ausgeschlossen werden
      return head.data;
    //else
    // return null;   //  Laufzeitfehler müssen laut Vorgaben bei der Anwendung der Operationen ausgeschlossen werden
  }
  
  /**
   * Ein neues Element mit dem übergebenen Inhalt wird an die Schlange angehängt.
   * @param data Der Inhalt für das neue Element.
   */ 
  public void enqueue(int data)
  {
    if (!isEmpty())
    {
      getElement(length-1).next = new Element(data);
    }
    else
    {
      head = new Element(data);
    }
    length++;
  }
  
  /**
   * Das erste Element der Schlange wird entnommen und dessen Inhalt zurückgegeben. 
   * @return Der Inhalt des entnommenen Elements.
   */
  public int dequeue()
  {
    //if (!isEmpty())    //  Laufzeitfehler müssen laut Vorgaben bei der Anwendung der Operationen ausgeschlossen werden
    //{
      Element temp = head;
      head = head.next;
      length--;
      return temp.data;
    //}
    // else
    //return null;   //  Laufzeitfehler müssen laut Vorgaben bei der Anwendung der Operationen ausgeschlossen werden
  }

  private Element getElement(int index)
  {  
    // Interne Hilfsoperation zum vereinfachten Zugriff auf die Elemente der Reihung
    // durch die öffentlichen Operationen
    if (length >= index)
    {
      Element current = head;
      for (int i=0; i < index; i++)
      {
        current = current.next;
      }
      return current;
    }
    return null;
  }

  // Klasse Element zur internen Verwaltung der einzelnen Elemente der Schlange
  private class Element
  {
    public int data;
    public Element next;

    public Element(int d)
    {
      data = d;
      next = null;
    }
  } //Ende der Klasse Element
} //Ende der Klasse Queue
