/*Autor: Ylva Brandt, Januar 2023
Dieses Werk ist lizenziert unter einer Creative Commons Namensnennung - Nicht-kommerziell - Weitergabe unter gleichen Bedingungen 4.0 International Lizenz (http://creativecommons.org/licenses/by-nc-sa/4.0/).
*/

//zweidimensionale Reihung; 
int[][] bild = new int[10][10];
int[][] kopie = new int[10][10];//eine Kopie des Originalbildes, in dem die Zwischenergebnisse gespeichert werden können

void setup(){
 size(600, 300);
 rasterZeichnen();
}

void draw(){
}

//Ein Raster für zwei 10 x 10 große Bilder wird gezeichnet
void rasterZeichnen(){
 background(255, 255, 255);
 stroke(0, 0, 0);
 for(int i = 0; i < 300; i = i+30){
   line(i, 0, i, height);
   line(300+i, 0, 300+i, height);
   line(0, i, width, i);
 }
 strokeWeight(3);
 line(300, 0, 300, 300);
 
 //Alle Pixel sind zunächst weiß (1)
 for(int i = 0; i < bild.length; i++){
   for(int j = 0; j < bild.length; j++){
     bild[i][j] = 1;
     kopie[i][j] = 1;
   }
 }
 strokeWeight(1);
}

//Wenn ein Feld im linken Bild angeklickt wird, welchselt es die Farbe und das rechte Bild wird zurückgesetzt
void mouseClicked(){
  //Maus-Koordinaten in entsprechende Indizes der Reihung umrechnen, wenn in die linke Hälfte geklickt wurde
  //x gibt die Spalte des Pixels an und wird daher als zweiter Index verwendet, y gibt die Zeile an und wird als erster Index verwendet
  int x,y = 0;
  if(mouseX < 300){
   x = (int)mouseX/30;
   y = (int)mouseY/30; 
  
  //Farbe des Feldes Wechseln
  if(bild[y][x] == 0) bild[y][x] = 1;
  else bild[y][x] = 0;
  
  fill(255*bild[y][x]);
  square(x*30,y*30,30);
  
  //in kopie wieder das Originalbild eintragen und anzeigen
  for(int i = 0; i < bild.length; i++){
   for(int j = 0; j < bild.length; j++){
     kopie[i][j] = bild[i][j];
   }
  }
  bildZeichnenRechts();
  
  System.out.println("x: " + x + ", y: " + y); //Ausgabe des gewählten Feldes zu Testzwecken
  }
}

void keyTyped(){
  if(key == 'r'){//reset-Button für ein neues leeres Bild
   rasterZeichnen();
  }
  if(key == 's'){
    spiegelbildZeichnen();
  }
  if(key == 'd'){
    drehungRechts();
  }
   
}

//das Bild in der 2D-Reihung kopie wird rechts gezeichnet 
void bildZeichnenRechts(){
for(int i = 0; i < kopie.length; i++){
    for(int j = 0; j < kopie[i].length; j++){
      fill(kopie[i][j]*255);
      square(300+j*30,i*30,30);
    }
  }
}

//In der 2D-Reihung kopie wird ein Spiegelbild des Bildes erstellt, das aktuell in Kopie enthalten ist 
void spiegelbildZeichnen(){
  //Hier eine passende Implementierung ergänzen  
}

//Das Bild, das aktuell in der 2D-Reihung kopie enthalten ist wird um 90° nach rechts gedreht. Das Ergebnis wird wieder in kopie gepseichert. 
void drehungRechts(){
 //Hier eine passende Implementierung ergänzen
}
