/*
 * Fab-Lab-Beispiel
 * ( http://fab-lab.eu/octopus/ )
 * Umgebaut fuer unsere Ansprueche
 */


#include <SPI.h>

#define PIN 13 //NeoPixl
 
#include <Wire.h>
#include <Adafruit_Sensor.h>
#include <Adafruit_BME280.h>
 
#define SEALEVELPRESSURE_HPA (1013.25)
 
Adafruit_BME280 bme; // I2C

void setup() 
{
    Serial.begin(115200);
   
    delay(1000);
     
    Serial.println(F("BME280 test"));
    if (!bme.begin()) 
    {
        Serial.println("Could not find a valid BME280 sensor, check wiring!");
        while (1);
    }
   
    delay(1000);
   
}
 
void loop() {

    /*
     * Fuer Debug auskommentieren
     
    Serial.print("Temperature = ");
    Serial.print(bme.readTemperature());
    Serial.println(" *C");
 
    Serial.print("Pressure = ");
 
    Serial.print(bme.readPressure() / 100.0F);
    Serial.println(" hPa");
 
    Serial.print("Approx. Altitude = ");
    Serial.print(bme.readAltitude(SEALEVELPRESSURE_HPA));
    Serial.println(" m");
 
    Serial.print("Humidity = ");
    Serial.print(bme.readHumidity());
    Serial.println(" %");
 
    Serial.println();
    */
    
    // Reihenfolge: Temp, Druck, Luftfeuchtigkeit, Identifier {
    Serial.print("(oc,");
    Serial.print(bme.readTemperature());
    Serial.print(",");
    Serial.print(bme.readPressure());
    Serial.print(",");
    Serial.print(bme.readHumidity());
    Serial.println(")");
    delay(100);
}
