/**
  * Beschreibung
  *
  * @version 2.0 vom 17.01.2024
  * @author Ylva Brandt
  */

import java.sql.*;
import java.io.PrintWriter;

public class DBManagerSQLite {
  
  // Anfang Attribute
  /** der Name der Datenbank */
  private String dbName = "schule_erweitert";
  
  /** ein Objekt für die Verbindung zur Datenbank*/
  private Connection verbindung;
  
  /** ein Objekt zum Absenden von SQL-Anfragen*/
  private Statement statement;
  // Ende Attribute
  
  /** erzeugt ein DBManagerSQLite-Objekt für die Datenbank schule_erweitert und stellt eine Verbindung zur Datenbank her*/
  public DBManagerSQLite() {
    //Status Informationen des DriverManagers ausgeben
    DriverManager.setLogWriter(new PrintWriter(System.out));
    
    //Treiber laden für ältere Versionen der sqlite-jdbc-XXX.jar 
    /*try{
      Class.forName("org.sqlite.JDBC");
    }catch(ClassNotFoundException e )
    {
      System.err.println( "Keine Treiber-Klasse!" );
      return;
    } */
    
    //Connection- und Statement-Objekt erzeugen
    try{
      verbindung = DriverManager.getConnection("jdbc:sqlite:" + dbName+".db");
      statement = verbindung.createStatement();
    }catch(SQLException e){
      e.printStackTrace();
    } 
  }
      
  /** erzeugt ein DBManagerSQLite-Objekt für die angegebene Datenbank und stellt eine Verbindung zur Datenbank her
  * @param dbName der Name der Datenbank
  */
  public DBManagerSQLite(String dbName) {
    this.dbName = dbName;
    //Status Informationen des DriverManagers ausgeben
    DriverManager.setLogWriter(new PrintWriter(System.out));
    
     //Treiber laden
    try{
      Class.forName("org.sqlite.JDBC");
    }catch(ClassNotFoundException e )
    {
      System.err.println( "Keine Treiber-Klasse!" );
      return;
    }
    
    //Connection- und Statement-Objekt erzeugen
    try{
      verbindung = DriverManager.getConnection("jdbc:sqlite:"+dbName + ".db");
      statement = verbindung.createStatement();
    }
    catch(SQLException e){
       System.out.println(e.toString());
       e.printStackTrace();
    }
  }
  
  
  // Anfang Methoden
  
  /**
  * führt die übergebene SQL-Anfrage aus
  * @param sqlAnfrage Die SQL-Anfrage, die ausgeführt werden soll, als Zeichenkette.
  * @return Das Ergebnis der SQL-Anfrage als zweidimensionale Reihung vom Typ Zeichenkette. Die oberste Zeile der Reihung enthält die Überschriften der Spalten. Danach folgt pro Datensatz eine Zeile mit den entsprechenden Werten. 
   * Diese werden unabhängig von den Datentypen der Datenbank als Zeichenkette gespeichert. Enthält eine Zelle in der Datenbank den Wert null, wird die Zeichenkette "null" in das entsprechende Feld der zweidimensionalen Reihung geschrieben.</br>
   * Schlägt der Versuch die SQL-Anfrage zu stellen fehl, enthält die zweidimensionale Reihung nur ein Feld mit dem Inhalt "Fehler".</br>
   * Der erste Index der Reihung gibt die Zeile an, der zweite die Spalte.
  */    
  public String[][] sqlAnfrageAusfuehren(String sqlAnfrage){
    //Rückgabe vorbereiten
    String[][] ergebnis = new String[1][1];
    ergebnis[0][0] = "Fehler";
    try{
      //falls die Verbindung schon wieder geschlossen wurde, muss sie neu aufgebaut werden und ein neues Statement-Objekt muss erzeugt werden.
      if (verbindung == null || verbindung.isClosed()) {
        System.out.println("neue Verbindung herstellen");
        verbindung = DriverManager.getConnection("jdbc:sqlite:"+dbName + ".db");
        statement = verbindung.createStatement();
      }
      
      //Das Ergebnis kommt als Java-Objekt vom Typ ResultSet zurück. Der Inhalt wird in die zweidimensionale Reihung übertragen und dies dann zurückgegeben.
      ResultSet myResultSet = statement.executeQuery(sqlAnfrage);
      ResultSetMetaData myRSMetaData = myResultSet.getMetaData();
      
      //zunaechst muss die Groesse der benoetigten Zeilen und Spalten in der Reihung bestimmt werden.  
      int spalten  = myRSMetaData.getColumnCount();
      int zeilen = 1;
      while(myResultSet.next()){
        zeilen++;
      }
      ergebnis = new String[zeilen][spalten];
      myResultSet.close();
          
      //Da das Resultset in Verbindung mit SQLite nur einmal durchlaufen werden kann, muss
      // die Anfrage hier nocheinmal gestellt werden, um ein neues Resultset zu erhalten, 
      // das nun in die Reihung uebertragen werden kann.
      myResultSet = statement.executeQuery(sqlAnfrage);
      myRSMetaData = myResultSet.getMetaData();
      
            
      //die erste Zeile mit den Spaltennamen füllen  
      int zeilenzaehler = 0;  
      for (int i = 1; i <= spalten; i++) {
        ergebnis[0][i-1] = myRSMetaData.getColumnName(i);
      } // end of for
      zeilenzaehler++;
      
      //die Datensaetze uebertragen
      while (myResultSet.next()) {
        for(int i = 1; i <= spalten; i++){
          ergebnis[zeilenzaehler][i-1] = myResultSet.getString(i);
          
          //enthält eine Zelle in der Datenbank den Wert null, wird die Zeichenkette "null" in das entsprechende Felde der zweidimensionalen Reihung geschrieben.
          if(myResultSet.wasNull()) ergebnis[zeilenzaehler][i-1] = "null";
        }
        zeilenzaehler++; 
      } // end of while
      myResultSet.close();
      
    }catch(SQLException e){
      e.printStackTrace();
    }
    return ergebnis; 
  }
  
  /**
  * führt die übergebene SQL-Einfüge-Anweisung aus
  * @param sql Die SQL-Anweisung, die ausgeführt werden soll, als Zeichenkette.
  * @return Die Anzahl der betroffenen Datensätze. Der Rückgabewert ist 0, wenn die Anweisung keine Änderung in der Datenbank bewirkt hat. 
  * Der Rückgabewert -1 zeigt an, dass ein Fehler aufgetreten ist.
  */   
  public int datensatzEinfuegen(String sql){
    int ergebnis = -1;
    try{
      //falls die Verbindung schon wieder geschlossen wurde, muss sie neu aufgebaut werden und ei neues Statement-Objekt muss erzeugt werden.
      if (verbindung == null || verbindung.isClosed()) {
        verbindung = DriverManager.getConnection("jdbc:sqlite:"+dbName + ".db");
        statement = verbindung.createStatement();
      }
    //Die SQL-Anweisung zum Einfügen wird ausgeführt und das Ergebnis durchgereicht.    
    ergebnis = statement.executeUpdate(sql);
    }catch(SQLException e){
       e.printStackTrace();
    }  
    return ergebnis;  
    } 
  
     /**
  * führt die übergebene SQL-Update-Anweisung aus
  * @param sql Die SQL-Anweisung, die ausgeführt werden soll, als Zeichenkette
  * @return Die Anzahl der betroffenen Datensätze. Der Rückgabewert ist 0, wenn die Anweisung keine Änderung in der Datenbank bewirkt hat. 
  * Der Rückgabewert -1 zeigt an, dass ein Fehler aufgetreten ist.
  */  
    public int datensatzAendern(String sql){
    int ergebnis = -1;
    try{
      //falls die Verbindung schon wieder geschlossen wurde, muss sie neu aufgebaut werden und ein neues Statement-Objekt muss erzeugt werden.
      if (verbindung == null || verbindung.isClosed()) {
        verbindung = DriverManager.getConnection("jdbc:sqlite:"+dbName + ".db");
        statement = verbindung.createStatement();
      }
      
    //Die SQL-Anweisung zum Ändern wird ausgeführt und das Ergebnis durchgereicht.
    ergebnis = statement.executeUpdate(sql);
    }catch(Exception e){
      e.printStackTrace();
    }  
    return ergebnis;  
    }
  
   /**
  * führt die übergebene SQL-Lösch-Anweisung aus
  * @param sql Die SQL-Anweisung, die ausgeführt werden soll, als Zeichenkette
  * @return Die Anzahl der betroffenen Datensätze. Der Rückgabewert ist 0, wenn die Anweisung keine Änderung in der Datenbank bewirkt hat. 
  * Der Rückgabewert -1 zeigt an, dass ein Fehler aufgetreten ist.
  */  
   public int datensatzLoeschen(String sql){
    int ergebnis = -1;
    try{
      //falls die Verbindung schon wieder geschlossen wurde, muss sie neu aufgebaut werden und ei neues Statement-Objekt muss erzeugt werden.
      if (verbindung == null || verbindung.isClosed()) {
        verbindung = DriverManager.getConnection("jdbc:sqlite:"+dbName + ".db");
        statement = verbindung.createStatement();
      }
      
    //Die SQL-Anweisung zum Löschen wird ausgeführt und das Ergebnis durchgereicht.  
    ergebnis = statement.executeUpdate(sql);
    }catch(Exception e){
      e.printStackTrace();
    }  
    return ergebnis;  
    }
  // Ende Methoden

} // end of DBManager

