import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 *
 * Beschreibung
 *
 * @version 1.0 vom 15.06.2022
 * @author Ylva Brandt
 */

public class SucheGebJahrgang extends JFrame {
  //Dialogelemente, die mithilfe des Objektinspektors und des Designformulars erzeugt wurden
  // Anfang Attribute
  private JLabel lGeburtsjahr = new JLabel();
  private JTextField tfJahr = new JTextField();
  private JButton bSucheSchueler = new JButton();
  private JTextArea taAusgabe = new JTextArea("");
  private JScrollPane taAusgabeScrollPane = new JScrollPane(taAusgabe);
  //Instanz der Hilfsklasse DBManagerSQLite für die Kommunikation mit der Datenbank
  private DBManagerSQLite myDBManager = new DBManagerSQLite();
  
  // Ende Attribute
  
  public SucheGebJahrgang() { 
    // Frame-Initialisierung
    super();
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 398; 
    int frameHeight = 300;
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    setTitle("SucheGebJahrgang");
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    taAusgabeScrollPane.setBounds(22, 149, 340, 100);
    taAusgabe.setEditable(false);                     
    cp.add(taAusgabeScrollPane);
    bSucheSchueler.setBounds(56, 96, 161, 41);
    bSucheSchueler.setText("suche Schüler");
    bSucheSchueler.setMargin(new Insets(2, 2, 2, 2));
    bSucheSchueler.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bSucheSchueler_ActionPerformed(evt);
      }
    });
    cp.add(bSucheSchueler);
    tfJahr.setBounds(104, 32, 150, 28);
    tfJahr.setText("2006");
    cp.add(tfJahr);
    lGeburtsjahr.setBounds(16, 32, 81, 25);
    lGeburtsjahr.setText("Geburtsjahr:");
    cp.add(lGeburtsjahr);
    
    // Ende Komponenten
    
    setVisible(true);
  } // end of public SucheGebJahrgang
  
  // Anfang Methoden
  
  public static void main(String[] args) {
    new SucheGebJahrgang();
  } // end of main
  
  public void bSucheSchueler_ActionPerformed(ActionEvent evt) {
    //Auslesen der Jahreszahl aus dem Textfeld
    String jahr = tfJahr.getText();
    
    //Zusammensetzen der SQL-Anfrage mithilfe der Variablen jahr
    String sql = "SELECT Vorname, Name, Geburtstag FROM schueler where Geburtstag like '"
    + jahr + "%' ;";
      
    //SQL-Anfrage an die Datenbank senden    
    String[][] ergebnis = myDBManager.sqlAnfrageAusfuehren(sql);
      
    //Zusammensetzen der Zeichenkette für die Ausgabe 
    //1. Fall: Es wurden Schüler gefunden, die in dem angegebenen Jahr geboren sind 
    taAusgabe.setText("Folgende Schüler:innen haben im Jahr " + jahr + " Geburtstag:" + "\n");
    if(ergebnis.length > 1){
      for(int i = 1; i < ergebnis.length;i++)  { 
        taAusgabe.append(ergebnis[i][0] + " " + ergebnis[i][1] + ", geboren am " + ergebnis[i][2]+"\n");
      }
    }else{
      //2. Fall: Beim Ausführen der Anfrage wurde ein Fehler in der SQL-Anweisung festgestellt
      if(ergebnis[0][0].equals("Fehler")) taAusgabe.setText("Es ist ein Fehler aufgetreten.");
  
      //3. Fall: Es wurden keine Schüler gefunden, die in dem angegebenen Jahr geboren wurden
      else taAusgabe.setText("Es gibt keine Schüler, die im Jahr " + jahr + " geboren wurden.");
    }
  } // end of bSucheSchueler_ActionPerformed

  // Ende Methoden
} // end of class SucheGebJahrgang
