/**
 *
 * Beschreibung: Beispiel für das Eintragen von zufälligen Attributwerten
 *
 * @version 1.0 vom 02.02.2024
 * @author Ylva Brandt
 */

public class DBZufallswerteEintragen{
  
  //bearbeitet wird die Datenbank schule
  static DBManagerSQLite myDBManager = new DBManagerSQLite("schule");
  
  //In der Reihung ortsteile stehen alle Zufallswerte, die für das Attribut Ortsteil in Frage kommen
  static private String[] ortsteile = {"Mausdorf", "Altenfelde", "Drachenwiese", "Kirschdorf", "Runingen"};
  
  //Eintragen der Zufallswerte in die Datenbank
  public static void main(String[] args) {
    
   //Zunächst werden alle Schüler IDs aus der Datenbank geholt 
   String sql = "select ID_nummer from schueler;";
   String[][] ergebnis = myDBManager.sqlAnfrageAusfuehren(sql);
    
   //Wenn die Abfrage erfolgreich war, werden die Schüler in einer Schleife durchlaufen. Für jeden Schüler wird mithilfe einer Zufallszahl ein Ortsteil ausgewählt.
   //Der Ortsteils wird mit der passenden Stadt als Ort in die Datenbank geschrieben.  
   if(ergebnis.length > 1){
      for (int i = 1; i < ergebnis.length; i++) {
        //Zufallszahl zwischen 0 und 4 generieren
        int zufallszahl = (int)(Math.random()*5);
                
        //Ortsteil aus der Reihung ortsteile auswählen mit der Zufallszahl als Index
        String ortsteil = ortsteile[zufallszahl];
        String stadt = "";
        //Die Ortsteile an Positon 0 und 1 gehören zu dem Ort Unterdorf, die Ortsteile an den Positionen 2 bis 4 zu Oberdorf       String stadt = "";
        if(zufallszahl < 2) stadt = "Unterdorf";
        else stadt = "Oberdorf";
         
        //Die SQL-Update-Anweisung zum Eintragen des Ortes und des Ortsteils in die Datenbank
        sql = "update schueler set Ort = '" + stadt + "', Ortsteil = '" + ortsteil + "' where ID_nummer = '" + ergebnis[i][0] + "';";
        System.out.println(sql);
        
        //Ausführen der Update-Anweisung und Ausgabe der Anzahl der geänderten Datensätze zur Kontrolle
        int geaendert = myDBManager.datensatzAendern(sql);
        System.out.println(geaendert);
      } // end of for
   }//end if    
  } // end of main

} // end of class DBZufallswerteEintragen

