import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 *
 * Beschreibung;
 * exemplarische Verwendung einer SQLite-Datenbank zum externen Speichern einer Highscorliste
 *
 * @version 1.0 vom 26.01.2024
 * @author Ylva Brandt
 */

public class ZahlenRaten extends JFrame {
  // Anfang Attribute
  private JLabel lGesuchtisteineZahlzwischen0und100 = new JLabel();
  private JLabel lName = new JLabel();
  private JRadioButton rbNeuhier = new JRadioButton();
  private JRadioButton rbSchonangemeldet = new JRadioButton();
  private JTextField tfName = new JTextField();
  private ButtonGroup buttonGroup1 = new ButtonGroup();
  private JButton bStarteSpiel = new JButton();
  private JLabel lMeinTipp = new JLabel();
  private JTextField tfTipp = new JTextField();
  private JButton bTippabgeben = new JButton();
  private JTextArea jTextAreaAusgabe = new JTextArea("");
  private JScrollPane jTextAreaAusgabeScrollPane = new JScrollPane(jTextAreaAusgabe);
  private JButton bBestenlisteanzeigen = new JButton();
  
  //DBManagerSQLLite-Objekt für die Kommunikation mit der Datenbank "Highscore"
  private DBManagerSQLite myDBManager = new DBManagerSQLite("Highscore");
  
  //Die Zahl, die geraten werden soll
  int zahl;
  
  //Die Versuche, die der Spieler benötigt, bis er die Zahl erraten hat
  int anzahlVersuche = 0;
  
  //Der Name des Spielers
  String name;
  // Ende Attribute
  
  public ZahlenRaten() { 
    // Frame-Initialisierung
    super();
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 643; 
    int frameHeight = 348;
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    setTitle("ZahlenRaten");
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    bBestenlisteanzeigen.setBounds(424, 164, 139, 33);
    bBestenlisteanzeigen.setText("Bestenliste anzeigen");
    bBestenlisteanzeigen.setMargin(new Insets(2, 2, 2, 2));
    bBestenlisteanzeigen.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bBestenlisteanzeigen_ActionPerformed(evt);
      }
    });
    cp.add(bBestenlisteanzeigen);
    jTextAreaAusgabeScrollPane.setBounds(26, 160, 368, 124);
    cp.add(jTextAreaAusgabeScrollPane);
    bTippabgeben.setBounds(424, 110, 139, 33);
    bTippabgeben.setText("Tipp abgeben");
    bTippabgeben.setMargin(new Insets(2, 2, 2, 2));
    bTippabgeben.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bTippabgeben_ActionPerformed(evt);
      }
    });
    cp.add(bTippabgeben);
    tfTipp.setBounds(265, 111, 126, 20);
    cp.add(tfTipp);
    lMeinTipp.setBounds(176, 111, 70, 20);
    lMeinTipp.setText("Mein Tipp:");
    cp.add(lMeinTipp);
    bStarteSpiel.setBounds(26, 109, 131, 33);
    bStarteSpiel.setText("starte Spiel");
    bStarteSpiel.setMargin(new Insets(2, 2, 2, 2));
    bStarteSpiel.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bStarteSpiel_ActionPerformed(evt);
      }
    });
    cp.add(bStarteSpiel);
    tfName.setBounds(107, 68, 150, 20);
    tfName.setText("");
    cp.add(tfName);
    rbSchonangemeldet.setBounds(430, 68, 140, 20);
    rbSchonangemeldet.setOpaque(false);
    rbSchonangemeldet.setText("schon angemeldet");
    buttonGroup1.add(rbSchonangemeldet);
    cp.add(rbSchonangemeldet);
    rbNeuhier.setBounds(304, 68, 100, 20);
    rbNeuhier.setOpaque(false);
    rbNeuhier.setText("neu hier");
    buttonGroup1.add(rbNeuhier);
    rbNeuhier.setSelected(true);
    cp.add(rbNeuhier);
    lName.setBounds(26, 68, 62, 20);
    lName.setText("Name:");
    cp.add(lName);
    lGesuchtisteineZahlzwischen0und100.setBounds(89, 28, 438, 20);
    lGesuchtisteineZahlzwischen0und100.setText("Gesucht ist eine Zahl zwischen 0 und 100!");
    lGesuchtisteineZahlzwischen0und100.setHorizontalAlignment(SwingConstants.CENTER);
    lGesuchtisteineZahlzwischen0und100.setHorizontalTextPosition(SwingConstants.CENTER);
    cp.add(lGesuchtisteineZahlzwischen0und100);
    
    // Ende Komponenten
    
    setVisible(true);
  }
  
  // Anfang Methoden
  
  public static void main(String[] args) {
    new ZahlenRaten();
  }
  public String buttonGroup1_getSelectedRadioButtonLabel() {
    for (java.util.Enumeration<AbstractButton> e = buttonGroup1.getElements(); e.hasMoreElements();) {
      AbstractButton b = e.nextElement();
      if (b.isSelected()) return b.getText();
    }
    return "";
  }

  public void bStarteSpiel_ActionPerformed(ActionEvent evt) {
    //Das Spiel darf erst gestartet werden, wenn ein Name angegeben wurde
    if(tfName.getText().equals(""))
     jTextAreaAusgabe.setText("Gib zuerst deinen Namen ein.");
    else{
      //um zu testen, ob für den Namen bereits ein Datensatz in der Datenbank existiert, wird nach dem Namen gesucht
      name = tfName.getText();
      String sql = "SELECT * FROM spieler where name = '" + name + "'";
      String[][] ergebnis = myDBManager.sqlAnfrageAusfuehren(sql);
      if(ergebnis.length > 1){//In diesem Fall wurde ein Datensatz gefunden
        if(rbNeuhier.isSelected())//Für einen neuen Spieler muss daher ein andere Name verwendet werden
           jTextAreaAusgabe.setText("Dieser Name ist bereits vergeben. \nBitte gib einen anderen Namen ein und starte das Spiel erneut.");
        else{//Der Spieler ist bereits eingetragen, daher kann es jetzt losgehen. 
          zahl = (int)(Math.random()*101); //Es wird eine Zufallszahl gewählt
          bTippabgeben.setEnabled(true); //Der Button zum Tipp abgeben wird aktiviert
          jTextAreaAusgabe.setText("Es kann losgehen!");
          anzahlVersuche = 0; //Der Zähler für die Versuche wird auf 0 gesetzt
          
        }
      }else{
        if(rbNeuhier.isSelected()){//Wenn es den Spieler noch nicht gibt, wird ein neuer Spieler in der Datenbank angelegt, der Rest ist wie oben
          sql = "INSERT INTO spieler (name) VALUES ('" + name + "');";
          myDBManager.datensatzEinfuegen(sql);
          zahl = (int)(Math.random()*101);
          bTippabgeben.setEnabled(true);
          jTextAreaAusgabe.setText("Es kann losgehen!");
          anzahlVersuche = 0;
         }
        else{//Wenn der Spieler sich schon einmal angemeldet hat, aber der Name nicht in der Datenbank gefunden wurde, muss der Name falsch sein
          jTextAreaAusgabe.setText("Der Name wurde nicht gefunden. \nWenn du deinen Namen vergessen hast, \nkannst du einen neuen Nutzer anlegen.");
        }
      }
      
    }
    
  }

  public void bTippabgeben_ActionPerformed(ActionEvent evt) {
    anzahlVersuche++; //Der Versuch wird gezählt
    if(tfTipp.equals(""))
      jTextAreaAusgabe.setText("Gib eine Zahl zwischen 0 und 100 bei Mein Tipp ein.");
    else{
      try{
        int tipp = Integer.parseInt(tfTipp.getText()); //Umwandeln des Tipps in eine Ganzzahl
        //Es wird nun getestet, ob die gesuchte Zahl kleiner oder größer als der Tipp ist oder ob die Zahl erraten wurde
        if(tipp > zahl) 
          jTextAreaAusgabe.setText("Die gesuchte Zahl ist kleiner.");
        else {
          if(tipp < zahl)
            jTextAreaAusgabe.setText("Die gesuchte Zahl ist größer.");
          else{
            jTextAreaAusgabe.setText(zahl + " ist die gesuchte Zahl. Du hast " + anzahlVersuche + " Versuche benötigt.");
            bTippabgeben.setEnabled(false); //Es dürfen keine weiteren Tipps mehr abgegeben werden
            
            //Die Anzahl der Versuche wird in die Datenbank eingetragen, wenn die persönliche Bestleistung übertroffen wurde
            String sql = "SELECT versuche FROM spieler WHERE name = '" + name + "';";
            String[][] ergebnis = myDBManager.sqlAnfrageAusfuehren(sql);
            if(ergebnis.length > 1){//Es gibt einen Spieler mit dem entsprechenden Namen
              if(!ergebnis[1][0].equals("null")){//Der Spieler hat das Spiel schon einmal gespielt. Somit gibt es einen alten Wert, der übertroffen werden muss
                int alt = Integer.parseInt(ergebnis[1][0]);
                if(alt > anzahlVersuche){//Wenn der neue Wert besser ist, wird er eingetragen
                  sql = "UPDATE spieler SET versuche = " + anzahlVersuche + " WHERE name = '" + name +"';";
                  myDBManager.datensatzAendern(sql);
                }
              }else{//Der Wert wird eingetragen, da es das erste Spiel war
                sql = "UPDATE spieler SET versuche = " + anzahlVersuche + " WHERE name = '" + name +"';";
                myDBManager.datensatzAendern(sql);
              }
            }else{//Da es noch keinen passenden Spieler gibt, wird er angelegt. Dieser Fall sollt eigentlich nicht auftreten
              sql = "INSERT INTO spieler (name, versuche) VALUES ('" + name + "', " + anzahlVersuche + ");";
              myDBManager.datensatzEinfuegen(sql);
            }
            
          }
        }
       //Falls keine gültige Zahl eingegeben wurde, wird die entsprechende Exception abgefangen und eine Meldung an den Anwender ausgegeben
      }catch(NumberFormatException e){
        jTextAreaAusgabe.setText("Das ist keine Zahl.");
      } 
    }
  }

  public void bBestenlisteanzeigen_ActionPerformed(ActionEvent evt) {
    String sql = "SELECT * FROM spieler WHERE versuche is not NULL ORDER BY versuche, name asc LIMIT 10;";
    String[][] ergebnis = myDBManager.sqlAnfrageAusfuehren(sql);
    String ausgabe = "Die 10 besten Spieler sind: ";
    for(int i = 1; i < ergebnis.length; i++){
      ausgabe = ausgabe + "\n " + ergebnis[i][0] + " mit " + ergebnis[i][1] + " Versuchen";
    }
    jTextAreaAusgabe.setText(ausgabe);
  }

  // Ende Methoden
}
