import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/**
 *
 * Beschreibung
 *
 * @version 1.0 vom 11.05.2023
 * @author Ylva Brandt
 * Dieses Werk ist lizenziert unter einer Creative Commons Namensnennung - Nicht-kommerziell - Weitergabe unter gleichen Bedingungen 4.0 International Lizenz (http://creativecommons.org/licenses/by-nc-sa/4.0/).
 */

public class RechteckeZeichnen extends JFrame {
  // Anfang Attribute
  private JButton bFaerbeBlau = new JButton();
  private JPanel jPanel1 = new JPanel(null, true);
  private JButton bAusgefuellt = new JButton();
  Rechteck[] rechtecke = new Rechteck[20];
  public int anzahl = 0;
  // Ende Attribute
  
  public RechteckeZeichnen() { 
    // Frame-Initialisierung
    super();
    setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    int frameWidth = 600; 
    int frameHeight = 400;
    setSize(frameWidth, frameHeight);
    Dimension d = Toolkit.getDefaultToolkit().getScreenSize();
    int x = (d.width - getSize().width) / 2;
    int y = (d.height - getSize().height) / 2;
    setLocation(x, y);
    setTitle("RechteckeZeichnen");
    setResizable(false);
    Container cp = getContentPane();
    cp.setLayout(null);
    // Anfang Komponenten
    bAusgefuellt.setBounds(168, 16, 137, 33);
    bAusgefuellt.setText("nicht ausgefuellt");
    bAusgefuellt.setMargin(new Insets(2, 2, 2, 2));
    bAusgefuellt.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bAusgefuellt_ActionPerformed(evt);
      }
    });
    cp.add(bAusgefuellt);
    jPanel1.setBounds(24, 80, 545, 249);
    jPanel1.setOpaque(true);
    jPanel1.addMouseListener(new MouseAdapter() { 
      public void mouseClicked(MouseEvent evt) { 
        jPanel1_MouseClicked(evt);
      }
    });
    jPanel1.setBackground(Color.YELLOW);
    cp.add(jPanel1);
    bFaerbeBlau.setBounds(24, 16, 121, 33);
    bFaerbeBlau.setText("faerbeBlau");
    bFaerbeBlau.setMargin(new Insets(2, 2, 2, 2));
    bFaerbeBlau.addActionListener(new ActionListener() { 
      public void actionPerformed(ActionEvent evt) { 
        bFaerbeBlau_ActionPerformed(evt);
      }
    });
    cp.add(bFaerbeBlau);
    rechtecke[0] = new Rechteck(100, 100, 40, 60);

     // Ende Komponenten
    
    setVisible(true);
  }
  
  // Anfang Methoden
  
  public static void main(String[] args) {
    new RechteckeZeichnen();
  }
  
  public void paint(Graphics g){
    super.paint(g);
    for(int i = 0; i <= anzahl; i++){
      rechtecke[i].zeichnen(jPanel1.getGraphics());  //Damit die Rechtecke auf dem JPanel gezeichnet werden, wird der Graphics Kontext an das JPanel übergeben
    
    }
  }
  
  public void bFaerbeBlau_ActionPerformed(ActionEvent evt) {
    for(int i = 0; i <= anzahl; i++){
      rechtecke[i].setFuellfarbe(0, 0, 255);
    }
    repaint();
  }

  public void jPanel1_MouseClicked(MouseEvent evt) {
    if(anzahl < rechtecke.length-1){
      anzahl ++;
      //System.out.println("x: "+ evt.getX() + "y: " + evt.getY()); //Testausgabe
      rechtecke[anzahl] = new Rechteck(evt.getX(), evt.getY(), 30, 60);
      repaint();
    }
  }

  public void bAusgefuellt_ActionPerformed(ActionEvent evt) {
    if(bAusgefuellt.getText().equals("ausgefuellt")){
      for(int i = 0; i <= anzahl; i++){
        rechtecke[i].setAusgefuellt(true);
      }
      bAusgefuellt.setText("nicht ausgefuellt");
    }else{
      for(int i = 0; i <= anzahl; i++){
        rechtecke[i].setAusgefuellt(false);
      }
      bAusgefuellt.setText("ausgefuellt");
    }
    repaint();  
  }

  // Ende Methoden
}
