/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.util;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;

public class PrintfFormat {
    private static NumberFormat nf = NumberFormat.getInstance(Locale.US);
    private static DecimalFormatSymbols dfs = new DecimalFormatSymbols(Locale.US);
    private static final int NDEC = 50;
    private static DecimalFormat[] dfe = new DecimalFormat[51];
    private static DecimalFormat[] dfg = new DecimalFormat[51];
    private StringBuffer sb;

    public PrintfFormat() {
        this.sb = new StringBuffer();
    }

    public PrintfFormat(int n) {
        this.sb = new StringBuffer(n);
    }

    public PrintfFormat(String string) {
        this.sb = new StringBuffer(string);
    }

    public PrintfFormat append(String string) {
        this.sb.append(string);
        return this;
    }

    public PrintfFormat append(int n, String string) {
        this.sb.append(PrintfFormat.s(n, string));
        return this;
    }

    public PrintfFormat append(double d) {
        this.sb.append(d);
        return this;
    }

    public PrintfFormat append(int n, double d) {
        this.sb.append(PrintfFormat.f(n, d));
        return this;
    }

    public PrintfFormat append(int n, int n2, double d) {
        this.sb.append(PrintfFormat.f(n, n2, d));
        return this;
    }

    public PrintfFormat append(int n) {
        this.sb.append(n);
        return this;
    }

    public PrintfFormat append(int n, int n2) {
        this.sb.append(PrintfFormat.d(n, n2));
        return this;
    }

    public PrintfFormat append(long l) {
        this.sb.append(l);
        return this;
    }

    public PrintfFormat append(int n, long l) {
        this.sb.append(PrintfFormat.d(n, l));
        return this;
    }

    public PrintfFormat append(int n, int n2, int n3, double d) {
        this.sb.append(PrintfFormat.format(n, n2, n3, d));
        return this;
    }

    public PrintfFormat append(char c) {
        this.sb.append(c);
        return this;
    }

    public void clear() {
        this.sb.setLength(0);
    }

    public StringBuffer getBuffer() {
        return this.sb;
    }

    public String toString() {
        return this.sb.toString();
    }

    public static String s(String string) {
        return string;
    }

    public static String s(int n, String string) {
        int n2 = Math.abs(n);
        if (string.length() < n2) {
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = string.length();
            for (int i = 0; i < n2 - n3; ++i) {
                stringBuffer.append(' ');
            }
            return n >= 0 ? stringBuffer.toString() + string : string + stringBuffer.toString();
        }
        return string;
    }

    public static String d(long l) {
        return PrintfFormat.d(0, 1, l);
    }

    public static String d(int n, long l) {
        return PrintfFormat.d(n, 1, l);
    }

    public static String d(int n, int n2, long l) {
        if (n2 < 0) {
            throw new IllegalArgumentException("precision must not be negative.");
        }
        if (n2 == 0 && l == 0L) {
            return PrintfFormat.s(n, "");
        }
        nf.setGroupingUsed(false);
        nf.setMinimumIntegerDigits(n2);
        nf.setMaximumFractionDigits(0);
        return PrintfFormat.s(n, nf.format(l));
    }

    public static String E(double d) {
        return PrintfFormat.E(0, 6, d);
    }

    public static String E(int n, double d) {
        return PrintfFormat.E(n, 6, d);
    }

    public static String E(int n, int n2, double d) {
        DecimalFormat decimalFormat;
        int n3;
        CharSequence charSequence;
        if (n2 < 0) {
            throw new IllegalArgumentException("precision must not be negative.");
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (Double.isInfinite(d)) {
            return (d < 0.0 ? "-" : "") + "Infinite";
        }
        if (n2 >= dfe.length || dfe[n2] == null) {
            charSequence = new StringBuffer("0.");
            for (n3 = 0; n3 < n2; ++n3) {
                ((StringBuffer)charSequence).append("0");
            }
            ((StringBuffer)charSequence).append("E00");
            decimalFormat = new DecimalFormat(((StringBuffer)charSequence).toString(), dfs);
            decimalFormat.setGroupingUsed(false);
            if (n2 < dfe.length) {
                PrintfFormat.dfe[n2] = decimalFormat;
            }
        } else {
            decimalFormat = dfe[n2];
        }
        if ((n3 = ((String)(charSequence = decimalFormat.format(d))).indexOf(69)) != -1 && ((String)charSequence).charAt(n3 + 1) != '-') {
            charSequence = ((String)charSequence).substring(0, n3 + 1) + "+" + ((String)charSequence).substring(n3 + 1);
        }
        return PrintfFormat.s(n, (String)charSequence);
    }

    public static String e(double d) {
        return PrintfFormat.e(0, 6, d);
    }

    public static String e(int n, double d) {
        return PrintfFormat.e(n, 6, d);
    }

    public static String e(int n, int n2, double d) {
        String string = PrintfFormat.E(n, n2, d);
        int n3 = string.indexOf(69);
        return n3 == -1 ? string : string.substring(0, n3) + 'e' + string.substring(n3 + 1);
    }

    public static String f(double d) {
        return PrintfFormat.f(0, 6, d);
    }

    public static String f(int n, double d) {
        return PrintfFormat.f(n, 6, d);
    }

    public static String f(int n, int n2, double d) {
        if (n2 < 0) {
            throw new IllegalArgumentException("precision must not be negative.");
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (Double.isInfinite(d)) {
            return (d < 0.0 ? "-" : "") + "Infinite";
        }
        nf.setGroupingUsed(false);
        nf.setMinimumIntegerDigits(1);
        nf.setMinimumFractionDigits(n2);
        nf.setMaximumFractionDigits(n2);
        return PrintfFormat.s(n, nf.format(d));
    }

    public static String G(double d) {
        return PrintfFormat.G(0, 6, d);
    }

    public static String G(int n, double d) {
        return PrintfFormat.G(n, 6, d);
    }

    public static String G(int n, int n2, double d) {
        DecimalFormat decimalFormat;
        int n3;
        CharSequence charSequence;
        if (n2 < 0) {
            throw new IllegalArgumentException("precision must not be negative.");
        }
        if (n2 == 0) {
            n2 = 1;
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (Double.isInfinite(d)) {
            return (d < 0.0 ? "-" : "") + "Infinite";
        }
        if (n2 >= dfg.length || dfg[n2] == null) {
            charSequence = new StringBuffer("0.");
            for (n3 = 0; n3 < n2 - 1; ++n3) {
                ((StringBuffer)charSequence).append("#");
            }
            ((StringBuffer)charSequence).append("E00");
            decimalFormat = new DecimalFormat(((StringBuffer)charSequence).toString(), dfs);
            decimalFormat.setGroupingUsed(false);
            if (n2 < dfg.length) {
                PrintfFormat.dfg[n2] = decimalFormat;
            }
        } else {
            decimalFormat = dfg[n2];
        }
        if ((n3 = ((String)(charSequence = decimalFormat.format(d))).indexOf(69)) == -1) {
            return charSequence;
        }
        int n4 = Integer.parseInt(((String)charSequence).substring(n3 + 1));
        if (n4 < -4 || n4 >= n2) {
            if (((String)charSequence).charAt(n3 + 1) != '-') {
                return PrintfFormat.s(n, ((String)charSequence).substring(0, n3 + 1) + "+" + ((String)charSequence).substring(n3 + 1));
            }
            return PrintfFormat.s(n, (String)charSequence);
        }
        nf.setGroupingUsed(false);
        nf.setMinimumIntegerDigits(1);
        nf.setMinimumFractionDigits(0);
        nf.setMaximumFractionDigits(n2 - n4 - 1);
        charSequence = nf.format(d);
        return PrintfFormat.s(n, (String)charSequence);
    }

    public static String g(double d) {
        return PrintfFormat.g(0, 6, d);
    }

    public static String g(int n, double d) {
        return PrintfFormat.g(n, 6, d);
    }

    public static String g(int n, int n2, double d) {
        String string = PrintfFormat.G(n, n2, d);
        int n3 = string.indexOf(69);
        return n3 == -1 ? string : string.substring(0, n3) + 'e' + string.substring(n3 + 1);
    }

    public static String format(int n, int n2, int n3, double d) {
        int n4;
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (Double.isInfinite(d)) {
            return (d < 0.0 ? "-" : "") + "Infinite";
        }
        int n5 = 0;
        int n6 = 0;
        if (d == 0.0) {
            n4 = 1;
        } else {
            n4 = n5 = (int)Math.floor(Math.log(Math.abs(d)) / Math.log(10.0) + 1.0);
            if (d < 0.0) {
                n6 = 1;
            }
        }
        if (n4 <= 0) {
            n5 = 1;
        }
        if (d == 0.0 || n4 + n2 >= n3 && n >= n5 + n2 + n6 + 1) {
            return PrintfFormat.f(n, n2, d);
        }
        String string = PrintfFormat.E(n, n3 - 1, d);
        int n7 = string.indexOf("E+0");
        if (n7 == -1) {
            n7 = string.indexOf("E-0");
        }
        if (n7 != -1) {
            string = " " + string.substring(0, n7 + 2) + string.substring(n7 + 3);
        }
        return string;
    }

    public static String format(long l) {
        return PrintfFormat.d(0, 1, l);
    }

    public static String format(int n, long l) {
        return PrintfFormat.d(n, 1, l);
    }

    public static String formatBase(int n, long l) {
        return PrintfFormat.formatBase(0, n, l);
    }

    public static String formatBase(int n, int n2, long l) {
        boolean bl = false;
        if (n2 < 2 || n2 > 10) {
            throw new IllegalArgumentException("base must be between 2 and 10.");
        }
        if (l < 0L) {
            bl = true;
            l = -l;
        } else {
            if (l == 0L) {
                return "0";
            }
            bl = false;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (l > 0L) {
            stringBuffer.insert(0, l % (long)n2);
            l /= (long)n2;
        }
        if (bl) {
            stringBuffer.insert(0, '-');
        }
        return PrintfFormat.s(n, stringBuffer.toString());
    }
}

