/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import umontreal.iro.lecuyer.rng.RandomStreamBase;
import umontreal.iro.lecuyer.util.BitMatrix;
import umontreal.iro.lecuyer.util.BitVector;

abstract class WELL607base
extends RandomStreamBase {
    static final double NORM = 2.3283064359965952E-10;
    static final int R = 19;
    static final int BUFFER_SIZE = 32;
    static final int NUM_BITS = 608;
    static final int MASK_STATE = 31;
    static final int W = 32;
    static final int P = 1;
    static final int MASKU = 1;
    static final int MASKL = -2;
    static final int M1 = 16;
    static final int M2 = 15;
    static final int M3 = 14;
    static final int R1 = 18;
    static final int R2 = 17;
    int state_i;
    int[] state;
    int[] stream;
    int[] substream;
    static final int w = 250;
    static final int v = 150;
    static BitMatrix Apw;
    static BitMatrix Apz;
    private static boolean initialised;
    static /* synthetic */ Class class$umontreal$iro$lecuyer$rng$WELL607base;

    WELL607base() {
    }

    static void initialisation() {
        if (initialised) {
            return;
        }
        try {
            InputStream inputStream = (class$umontreal$iro$lecuyer$rng$WELL607base == null ? (class$umontreal$iro$lecuyer$rng$WELL607base = WELL607base.class$("umontreal.iro.lecuyer.rng.WELL607base")) : class$umontreal$iro$lecuyer$rng$WELL607base).getClassLoader().getResourceAsStream("umontreal/iro/lecuyer/rng/WELL607.dat");
            ObjectInputStream objectInputStream = new ObjectInputStream(inputStream);
            Apw = (BitMatrix)objectInputStream.readObject();
            Apz = (BitMatrix)objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Couldn't find WELL607.dat");
            System.err.println(fileNotFoundException);
            System.exit(1);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            System.exit(1);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println(classNotFoundException);
            System.exit(1);
        }
        initialised = true;
    }

    static void advanceSeed(int[] nArray, BitMatrix bitMatrix) {
        BitVector bitVector = new BitVector(nArray, 608);
        bitVector = bitMatrix.multiply(bitVector);
        for (int i = 0; i < 19; ++i) {
            nArray[i] = bitVector.getInt(i);
        }
    }

    static void verifySeed(int[] nArray) {
        if (nArray.length != 19) {
            throw new IllegalArgumentException("Seed must contain 19 values");
        }
        boolean bl = false;
        for (int i = 0; !bl && i < 19; ++i) {
            if (nArray[i] == 0) continue;
            bl = true;
        }
        if (!bl && nArray[18] == Integer.MIN_VALUE) {
            throw new IllegalArgumentException("At least one of the element of the seed must not be 0. If this element is the last one, it mustn't be equal to 0x80000000 (-2147483648).");
        }
    }

    int[] getState() {
        int[] nArray = new int[19];
        for (int i = 0; i < 19; ++i) {
            nArray[i] = this.state[this.state_i + i & 0x1F];
        }
        return nArray;
    }

    String stringState() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 18; ++i) {
            stringBuffer.append(this.state[this.state_i + i & 0x1F] + ", ");
        }
        stringBuffer.append(this.state[this.state_i + 19 - 1 & 0x1F] + "}");
        return stringBuffer.toString();
    }

    int nextInt() {
        int n = this.state[this.state_i + 18 & 0x1F] & 0xFFFFFFFE | this.state[this.state_i + 17 & 0x1F] & 1;
        int n2 = this.state[this.state_i] ^ this.state[this.state_i] >>> 19 ^ (this.state[this.state_i + 16 & 0x1F] ^ this.state[this.state_i + 16 & 0x1F] >>> 11);
        int n3 = this.state[this.state_i + 15 & 0x1F] ^ this.state[this.state_i + 15 & 0x1F] << 14 ^ this.state[this.state_i + 14 & 0x1F];
        this.state[this.state_i] = n2 ^ n3;
        this.state[this.state_i - 1 & 0x1F] = n ^ n >>> 18 ^ n2 ^ (this.state[this.state_i] ^ this.state[this.state_i] << 5);
        --this.state_i;
        this.state_i &= 0x1F;
        return this.state[this.state_i];
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        initialised = false;
    }
}

