/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import umontreal.iro.lecuyer.rng.WELL607base;
import umontreal.iro.lecuyer.util.BitMatrix;
import umontreal.iro.lecuyer.util.BitVector;

public class WELL607
extends WELL607base {
    private static int[] curr_stream = new int[]{-693127396, -2102546034, 846098766, -1309785418, -240634643, 78534433, -974510013, -100396693, 1791890671, -849903200, 1797223196, 2117832253, -1959469526, 1961629173, -2064924138, -2081805215, -458736866, -1512559431, -1642435447};

    public WELL607() {
        WELL607.initialisation();
        this.state = new int[32];
        this.stream = new int[19];
        this.substream = new int[19];
        for (int i = 0; i < 19; ++i) {
            this.stream[i] = curr_stream[i];
        }
        WELL607.advanceSeed(curr_stream, Apz);
        this.resetStartStream();
    }

    public WELL607(String string) {
        this();
        this.name = string;
    }

    public static void setPackageSeed(int[] nArray) {
        WELL607.verifySeed(nArray);
        for (int i = 0; i < 19; ++i) {
            WELL607.curr_stream[i] = nArray[i];
        }
    }

    public void setSeed(int[] nArray) {
        WELL607.verifySeed(nArray);
        for (int i = 0; i < 19; ++i) {
            this.stream[i] = nArray[i];
        }
        this.resetStartStream();
    }

    public int[] getState() {
        return super.getState();
    }

    public void resetStartStream() {
        for (int i = 0; i < 19; ++i) {
            this.substream[i] = this.stream[i];
        }
        this.resetStartSubstream();
    }

    public void resetStartSubstream() {
        this.state_i = 0;
        for (int i = 0; i < 19; ++i) {
            this.state[i] = this.substream[i];
        }
    }

    public void resetNextSubstream() {
        WELL607.advanceSeed(this.substream, Apw);
        this.resetStartSubstream();
    }

    public String formatState() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.name == null) {
            stringBuffer.append("The state of this WELL607 is : {");
        } else {
            stringBuffer.append("The state of " + this.name + " is : {");
        }
        stringBuffer.append(super.stringState());
        return stringBuffer.toString();
    }

    protected double nextValue() {
        long l = this.nextInt();
        if (l <= 0L) {
            l += 0x100000000L;
        }
        return (double)l * 2.3283064359965952E-10;
    }

    public static void main(String[] stringArray) {
        if (stringArray.length < 1) {
            System.err.println("Must provide the output file.");
            System.exit(1);
        }
        System.out.println("Creating the WELL607 state transition matrices.");
        BitVector[] bitVectorArray = new BitVector[608];
        int[] nArray = new int[32];
        int[] nArray2 = new int[19];
        for (int i = 0; i < 608; ++i) {
            int n;
            for (n = 0; n < 32; ++n) {
                nArray[n] = 0;
            }
            nArray[i / 32] = 1 << i % 32;
            int n2 = nArray[18] & 0xFFFFFFFE | nArray[17] & 1;
            int n3 = nArray[0] ^ nArray[0] >>> 19 ^ (nArray[16] ^ nArray[16] >>> 11);
            int n4 = nArray[15] ^ nArray[15] << 14 ^ nArray[14];
            nArray[0] = n3 ^ n4;
            nArray[31] = n2 ^ n2 >>> 18 ^ n3 ^ (nArray[0] ^ nArray[0] << 5);
            for (n = 0; n < 19; ++n) {
                nArray2[n] = nArray[n - 1 & 0x1F];
            }
            bitVectorArray[i] = new BitVector(nArray2, 608);
        }
        BitMatrix bitMatrix = new BitMatrix(bitVectorArray).transpose();
        BitMatrix bitMatrix2 = bitMatrix.power2e(250);
        BitMatrix bitMatrix3 = bitMatrix2.power2e(150);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(stringArray[0]);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(bitMatrix2);
            objectOutputStream.writeObject(bitMatrix3);
            objectOutputStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("Couldn't create " + stringArray[0]);
            System.err.println(fileNotFoundException);
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
    }
}

