/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.rng.RandomStreamBase;
import umontreal.iro.lecuyer.util.ArithmeticMod;
import umontreal.iro.lecuyer.util.PrintfFormat;

public class MRG32k3a
extends RandomStreamBase {
    private static final double m1 = 4.294967087E9;
    private static final double m2 = 4.294944443E9;
    private static final double a12 = 1403580.0;
    private static final double a13n = 810728.0;
    private static final double a21 = 527612.0;
    private static final double a23n = 1370589.0;
    private static final double two17 = 131072.0;
    private static final double two53 = 9.007199254740992E15;
    private static final double invtwo24 = 5.960464477539063E-8;
    private static final double norm = 2.328306549295728E-10;
    private static final double[][] A1p0 = new double[][]{{0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {-810728.0, 1403580.0, 0.0}};
    private static final double[][] A2p0 = new double[][]{{0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}, {-1370589.0, 0.0, 527612.0}};
    private static final double[][] A1p76 = new double[][]{{8.2758667E7, 1.871391091E9, 4.127413238E9}, {3.672831523E9, 6.9195019E7, 1.871391091E9}, {3.672091415E9, 3.528743235E9, 6.9195019E7}};
    private static final double[][] A2p76 = new double[][]{{1.511326704E9, 3.759209742E9, 1.610795712E9}, {4.292754251E9, 1.511326704E9, 3.889917532E9}, {3.859662829E9, 4.292754251E9, 3.70846608E9}};
    private static final double[][] A1p127 = new double[][]{{2.427906178E9, 3.580155704E9, 9.49770784E8}, {2.26153695E8, 1.230515664E9, 3.580155704E9}, {1.988835001E9, 9.86791581E8, 1.230515664E9}};
    private static final double[][] A2p127 = new double[][]{{1.464411153E9, 2.77697599E8, 1.610723613E9}, {3.218393E7, 1.464411153E9, 1.022607788E9}, {2.824425944E9, 3.218393E7, 2.093834863E9}};
    private static double[] nextSeed = new double[]{12345.0, 12345.0, 12345.0, 12345.0, 12345.0, 12345.0};
    private double Cg0;
    private double Cg1;
    private double Cg2;
    private double Cg3;
    private double Cg4;
    private double Cg5;
    private double[] Bg = new double[6];
    private double[] Ig = new double[6];

    private static void multMatVect(double[] dArray, double[][] dArray2, double d, double[][] dArray3, double d2) {
        int n;
        double[] dArray4 = new double[3];
        for (n = 0; n < 3; ++n) {
            dArray4[n] = dArray[n];
        }
        ArithmeticMod.matVecModM(dArray2, dArray4, dArray4, d);
        for (n = 0; n < 3; ++n) {
            dArray[n] = dArray4[n];
        }
        for (n = 0; n < 3; ++n) {
            dArray4[n] = dArray[n + 3];
        }
        ArithmeticMod.matVecModM(dArray3, dArray4, dArray4, d2);
        for (n = 0; n < 3; ++n) {
            dArray[n + 3] = dArray4[n];
        }
    }

    public MRG32k3a() {
        this.name = null;
        this.anti = false;
        this.prec53 = false;
        for (int i = 0; i < 6; ++i) {
            this.Ig[i] = nextSeed[i];
        }
        this.resetStartStream();
        MRG32k3a.multMatVect(nextSeed, A1p127, 4.294967087E9, A2p127, 4.294944443E9);
    }

    public MRG32k3a(String string) {
        this();
        this.name = string;
    }

    public static void setPackageSeed(long[] lArray) {
        if (lArray.length != 6) {
            throw new IllegalArgumentException("Seed must contain 6 values");
        }
        if (lArray[0] == 0L && lArray[1] == 0L && lArray[2] == 0L) {
            throw new IllegalArgumentException("The first 3 values must not be 0");
        }
        if (lArray[5] == 0L && lArray[3] == 0L && lArray[4] == 0L) {
            throw new IllegalArgumentException("The last 3 values must not be 0");
        }
        if (lArray[0] >= 0xFFFFFF2FL || lArray[1] >= 0xFFFFFF2FL || lArray[2] >= 0xFFFFFF2FL) {
            throw new IllegalArgumentException("The first 3 values must be less than 4294967087");
        }
        if (lArray[5] >= 4294944443L || lArray[3] >= 4294944443L || lArray[4] >= 4294944443L) {
            throw new IllegalArgumentException("The last 3 values must be less than 4294944443");
        }
        for (int i = 0; i < 6; ++i) {
            MRG32k3a.nextSeed[i] = lArray[i];
        }
    }

    public void setSeed(long[] lArray) {
        if (lArray.length != 6) {
            throw new IllegalArgumentException("Seed must contain 6 values");
        }
        if (lArray[0] == 0L && lArray[1] == 0L && lArray[2] == 0L) {
            throw new IllegalArgumentException("The first 3 values must not be 0");
        }
        if (lArray[3] == 0L && lArray[4] == 0L && lArray[5] == 0L) {
            throw new IllegalArgumentException("The last 3 values must not be 0");
        }
        if (lArray[0] >= 0xFFFFFF2FL || lArray[1] >= 0xFFFFFF2FL || lArray[2] >= 0xFFFFFF2FL) {
            throw new IllegalArgumentException("The first 3 values must be less than 4294967087");
        }
        if (lArray[3] >= 4294944443L || lArray[4] >= 4294944443L || lArray[5] >= 4294944443L) {
            throw new IllegalArgumentException("The last 3 values must be less than 4294944443");
        }
        for (int i = 0; i < 6; ++i) {
            this.Ig[i] = lArray[i];
        }
        this.resetStartStream();
    }

    public void resetStartStream() {
        for (int i = 0; i < 6; ++i) {
            this.Bg[i] = this.Ig[i];
        }
        this.resetStartSubstream();
    }

    public void resetStartSubstream() {
        this.Cg0 = this.Bg[0];
        this.Cg1 = this.Bg[1];
        this.Cg2 = this.Bg[2];
        this.Cg3 = this.Bg[3];
        this.Cg4 = this.Bg[4];
        this.Cg5 = this.Bg[5];
    }

    public void resetNextSubstream() {
        MRG32k3a.multMatVect(this.Bg, A1p76, 4.294967087E9, A2p76, 4.294944443E9);
        this.resetStartSubstream();
    }

    public double[] getState() {
        return new double[]{this.Cg0, this.Cg1, this.Cg2, this.Cg3, this.Cg4, this.Cg5};
    }

    public String formatState() {
        PrintfFormat printfFormat = new PrintfFormat();
        printfFormat.append("The current state of the MRG32k3a");
        if (this.name != null && this.name.length() > 0) {
            printfFormat.append(" " + this.name);
        }
        printfFormat.append(":\n   Cg = { ");
        printfFormat.append((long)this.Cg0 + ", ");
        printfFormat.append((long)this.Cg1 + ", ");
        printfFormat.append((long)this.Cg2 + ", ");
        printfFormat.append((long)this.Cg3 + ", ");
        printfFormat.append((long)this.Cg4 + ", ");
        printfFormat.append((long)this.Cg5 + " }\n\n");
        return printfFormat.toString();
    }

    public String formatStateFull() {
        int n;
        PrintfFormat printfFormat = new PrintfFormat();
        printfFormat.append("The MRG32k3a");
        if (this.name != null && this.name.length() > 0) {
            printfFormat.append(" " + this.name);
        }
        printfFormat.append(":\n   anti = " + (this.anti ? "true" : "false")).append('\n');
        printfFormat.append(":\n prec53 = " + (this.prec53 ? "true" : "false")).append('\n');
        printfFormat.append("   Ig = { ");
        for (n = 0; n < 5; ++n) {
            printfFormat.append((long)this.Ig[n] + ", ");
        }
        printfFormat.append((long)this.Ig[5] + " }\n");
        printfFormat.append("   Bg = { ");
        for (n = 0; n < 5; ++n) {
            printfFormat.append((long)this.Bg[n] + ", ");
        }
        printfFormat.append((long)this.Bg[5] + " }\n");
        printfFormat.append("   Cg = { ");
        printfFormat.append((long)this.Cg0 + ", ");
        printfFormat.append((long)this.Cg1 + ", ");
        printfFormat.append((long)this.Cg2 + ", ");
        printfFormat.append((long)this.Cg3 + ", ");
        printfFormat.append((long)this.Cg4 + ", ");
        printfFormat.append((long)this.Cg5 + " }\n\n");
        return printfFormat.toString();
    }

    protected double nextValue() {
        int n;
        double d = 1403580.0 * this.Cg1 - 810728.0 * this.Cg0;
        if ((d -= (double)(n = (int)(d / 4.294967087E9)) * 4.294967087E9) < 0.0) {
            d += 4.294967087E9;
        }
        this.Cg0 = this.Cg1;
        this.Cg1 = this.Cg2;
        this.Cg2 = d;
        double d2 = 527612.0 * this.Cg5 - 1370589.0 * this.Cg3;
        if ((d2 -= (double)(n = (int)(d2 / 4.294944443E9)) * 4.294944443E9) < 0.0) {
            d2 += 4.294944443E9;
        }
        this.Cg3 = this.Cg4;
        this.Cg4 = this.Cg5;
        this.Cg5 = d2;
        return d > d2 ? (d - d2) * 2.328306549295728E-10 : (d - d2 + 4.294967087E9) * 2.328306549295728E-10;
    }
}

