/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.rng.RandomStreamBase;

public class LFSR113
extends RandomStreamBase {
    private static final double NORM = 2.3283064359965952E-10;
    private int z0;
    private int z1;
    private int z2;
    private int z3;
    private int[] stream;
    private int[] substream;
    private static int[] curr_stream = new int[]{12345, 12345, 12345, 12345};

    public LFSR113() {
        int n;
        this.name = null;
        this.stream = new int[4];
        this.substream = new int[4];
        for (n = 0; n < 4; ++n) {
            this.stream[n] = curr_stream[n];
        }
        this.resetStartStream();
        n = curr_stream[0] & 0xFFFFFFFE;
        int n2 = n << 6 ^ n;
        LFSR113.curr_stream[0] = n = n ^ n << 2 ^ n << 3 ^ n << 10 ^ n << 13 ^ n << 16 ^ n << 19 ^ n << 22 ^ n << 25 ^ n << 27 ^ n << 28 ^ n2 >>> 3 ^ n2 >>> 4 ^ n2 >>> 6 ^ n2 >>> 9 ^ n2 >>> 12 ^ n2 >>> 15 ^ n2 >>> 18 ^ n2 >>> 21;
        n = curr_stream[1] & 0xFFFFFFF8;
        n2 = n << 2 ^ n;
        LFSR113.curr_stream[1] = n = n2 >>> 13 ^ n << 16;
        n = curr_stream[2] & 0xFFFFFFF0;
        n2 = n << 13 ^ n;
        LFSR113.curr_stream[2] = n = n << 2 ^ n << 4 ^ n << 10 ^ n << 12 ^ n << 13 ^ n << 17 ^ n << 25 ^ n2 >>> 3 ^ n2 >>> 11 ^ n2 >>> 15 ^ n2 >>> 16 ^ n2 >>> 24;
        n = curr_stream[3] & 0xFFFFFF80;
        n2 = n << 3 ^ n;
        LFSR113.curr_stream[3] = n = n << 9 ^ n << 10 ^ n << 11 ^ n << 14 ^ n << 16 ^ n << 18 ^ n << 23 ^ n << 24 ^ n2 >>> 1 ^ n2 >>> 2 ^ n2 >>> 7 ^ n2 >>> 9 ^ n2 >>> 11 ^ n2 >>> 14 ^ n2 >>> 15 ^ n2 >>> 16 ^ n2 >>> 23 ^ n2 >>> 24;
    }

    public LFSR113(String string) {
        this();
        this.name = string;
    }

    public static void setPackageSeed(int[] nArray) {
        if (nArray.length != 4) {
            throw new IllegalArgumentException("Seed must contain 4 values");
        }
        if (nArray[0] < 2 || nArray[1] < 8 || nArray[2] < 16 || nArray[3] < 128) {
            throw new IllegalArgumentException("The seed elements must be greater or equal than 2, 8, 16 and 128 respectively");
        }
        for (int i = 0; i < 4; ++i) {
            LFSR113.curr_stream[i] = nArray[i];
        }
    }

    public void setSeed(int[] nArray) {
        if (nArray.length != 4) {
            throw new IllegalArgumentException("Seed must contain 4 values");
        }
        if (nArray[0] < 2 || nArray[1] < 8 || nArray[2] < 16 || nArray[3] < 128) {
            throw new IllegalArgumentException("The seed elements must be greater or equal than 2, 8, 16 and 128 respectively");
        }
        for (int i = 0; i < 4; ++i) {
            this.stream[i] = nArray[i];
        }
        this.resetStartStream();
    }

    public int[] getState() {
        return new int[]{this.z0, this.z1, this.z2, this.z3};
    }

    public void resetStartStream() {
        for (int i = 0; i < 4; ++i) {
            this.substream[i] = this.stream[i];
        }
        this.resetStartSubstream();
    }

    public void resetStartSubstream() {
        this.z0 = this.substream[0];
        this.z1 = this.substream[1];
        this.z2 = this.substream[2];
        this.z3 = this.substream[3];
    }

    public void resetNextSubstream() {
        int n = this.substream[0] & 0xFFFFFFFE;
        int n2 = n << 6 ^ n;
        n = n ^ n << 3 ^ n << 4 ^ n << 6 ^ n << 7 ^ n << 8 ^ n << 10 ^ n << 11 ^ n << 13 ^ n << 14 ^ n << 16 ^ n << 17 ^ n << 18 ^ n << 22 ^ n << 24 ^ n << 25 ^ n << 26 ^ n << 28 ^ n << 30;
        this.substream[0] = n ^= n2 >>> 1 ^ n2 >>> 3 ^ n2 >>> 5 ^ n2 >>> 6 ^ n2 >>> 7 ^ n2 >>> 9 ^ n2 >>> 13 ^ n2 >>> 14 ^ n2 >>> 15 ^ n2 >>> 17 ^ n2 >>> 18 ^ n2 >>> 20 ^ n2 >>> 21 ^ n2 >>> 23 ^ n2 >>> 24 ^ n2 >>> 25 ^ n2 >>> 26 ^ n2 >>> 27 ^ n2 >>> 30;
        n = this.substream[1] & 0xFFFFFFF8;
        n2 = n ^ n << 1;
        n2 ^= n2 << 2;
        n2 ^= n2 << 4;
        n2 ^= n2 << 8;
        n2 <<= 8;
        n2 ^= n << 22 ^ n << 25 ^ n << 27;
        if ((n & Integer.MIN_VALUE) != 0) {
            n2 ^= 0xABFFF000;
        }
        if ((n & 0x40000000) != 0) {
            n2 ^= 0x55FFF800;
        }
        this.substream[1] = n = n2 ^ n >>> 7 ^ n >>> 20 ^ n >>> 21;
        n = this.substream[2] & 0xFFFFFFF0;
        n2 = n << 13 ^ n;
        this.substream[2] = n = n2 >>> 3 ^ n2 >>> 17 ^ n << 10 ^ n << 11 ^ n << 25;
        n = this.substream[3] & 0xFFFFFF80;
        n2 = n << 3 ^ n;
        this.substream[3] = n = n << 14 ^ n << 16 ^ n << 20 ^ n2 >>> 5 ^ n2 >>> 9 ^ n2 >>> 11;
        this.resetStartSubstream();
    }

    public String formatState() {
        if (this.name == null) {
            return "The state of the LFSR113 is : " + this.z0 + "," + this.z1 + "," + this.z2 + "," + this.z3 + ".";
        }
        return "The state of the " + this.name + " is : " + this.z0 + "," + this.z1 + "," + this.z2 + "," + this.z3 + ".";
    }

    protected double nextValue() {
        int n = (this.z0 << 6 ^ this.z0) >>> 13;
        this.z0 = (this.z0 & 0xFFFFFFFE) << 18 ^ n;
        n = (this.z1 << 2 ^ this.z1) >>> 27;
        this.z1 = (this.z1 & 0xFFFFFFF8) << 2 ^ n;
        n = (this.z2 << 13 ^ this.z2) >>> 21;
        this.z2 = (this.z2 & 0xFFFFFFF0) << 7 ^ n;
        n = (this.z3 << 3 ^ this.z3) >>> 12;
        this.z3 = (this.z3 & 0xFFFFFF80) << 13 ^ n;
        long l = this.z0 ^ this.z1 ^ this.z2 ^ this.z3;
        if (l <= 0L) {
            l += 0x100000000L;
        }
        return (double)l * 2.3283064359965952E-10;
    }
}

