/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.rng;

import umontreal.iro.lecuyer.rng.F2wPoly;
import umontreal.iro.lecuyer.rng.RandomStreamBase;

public class GenF2w2_32
extends RandomStreamBase {
    private static final double NORM = 2.3283064359965952E-10;
    private static final int Z0 = Integer.MIN_VALUE;
    private static final int W = 32;
    private static final int R = 25;
    private static final int T = 7;
    private static final int W1 = 11;
    private static final int W2 = 11;
    private static final int W3 = 10;
    private static final int Wsplit1 = 21;
    private static final int Wsplit2 = 10;
    private static final int MASK1 = -2097152;
    private static final int MASK2 = 2096128;
    private static final int MASK3 = 1023;
    private static int[] BrmT1;
    private static int[] BrmT2;
    private static int[] BrmT3;
    private static int[] Br1;
    private static int[] Br2;
    private static int[] Br3;
    private static final int BrmT = -425292512;
    private static final int Br = 679131202;
    private static final int modQ = -95446209;
    private static final int w = 300;
    private static final int v = 200;
    private static F2wPoly.F2wPolyElem jumpW;
    private static F2wPoly.F2wPolyElem jumpZ;
    private static F2wPoly polyBase;
    private static F2wPoly.F2wPolyElem curr_stream;
    private F2wPoly.F2wPolyElem stream = polyBase.createElem();
    private F2wPoly.F2wPolyElem substream = polyBase.createElem();
    private int[] state = new int[25];
    private int state_i;

    private static int multiplyZ(int n, int n2, int n3) {
        for (int i = 0; i < n2; ++i) {
            if ((n & 1) != 0) {
                n = n >>> 1 ^ n3;
                continue;
            }
            n >>>= 1;
        }
        return n;
    }

    private static int multiply(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 1;
        for (int i = 0; i < 32; ++i) {
            if ((n2 & n5) != 0) {
                n4 ^= GenF2w2_32.multiplyZ(n, 31 - i, n3);
            }
            n5 <<= 1;
        }
        return n4;
    }

    private static void initTables() {
        int n;
        BrmT1 = new int[2048];
        Br1 = new int[2048];
        BrmT2 = new int[2048];
        Br2 = new int[2048];
        BrmT3 = new int[1024];
        Br3 = new int[1024];
        for (n = 0; n < Br1.length; ++n) {
            GenF2w2_32.BrmT1[n] = GenF2w2_32.multiply(-425292512, n << 21, -95446209);
            GenF2w2_32.Br1[n] = GenF2w2_32.multiply(679131202, n << 21, -95446209);
        }
        for (n = 0; n < Br2.length; ++n) {
            GenF2w2_32.BrmT2[n] = GenF2w2_32.multiply(-425292512, n << 10, -95446209);
            GenF2w2_32.Br2[n] = GenF2w2_32.multiply(679131202, n << 10, -95446209);
        }
        for (n = 0; n < Br3.length; ++n) {
            GenF2w2_32.BrmT3[n] = GenF2w2_32.multiply(-425292512, n, -95446209);
            GenF2w2_32.Br3[n] = GenF2w2_32.multiply(679131202, n, -95446209);
        }
    }

    public GenF2w2_32() {
        this.stream.copyFrom(curr_stream);
        curr_stream = curr_stream.multiply(jumpZ);
        this.resetStartStream();
    }

    public GenF2w2_32(String string) {
        this();
        this.name = string;
    }

    public static void setPackageSeed(int[] nArray) {
        if (nArray.length != 25) {
            throw new IllegalArgumentException("Seed must contain 25values.");
        }
        boolean bl = false;
        for (int i = 0; i < 25; ++i) {
            if (nArray[i] == 0) continue;
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("At least one part of the seed must be non-zero.");
        }
        curr_stream = polyBase.createElem(nArray);
    }

    public void setSeed(int[] nArray) {
        if (nArray.length != 25) {
            throw new IllegalArgumentException("Seed must contain 25values.");
        }
        boolean bl = false;
        for (int i = 0; i < 25; ++i) {
            if (nArray[i] == 0) continue;
            bl = true;
        }
        if (!bl) {
            throw new IllegalArgumentException("At least one part of the seed must be non-zero.");
        }
        this.stream = polyBase.createElem(nArray);
        this.resetStartStream();
    }

    public int[] getState() {
        int[] nArray = new int[25];
        for (int i = 0; i < 25; ++i) {
            nArray[i] = this.state[(this.state_i + i) % 25];
        }
        return nArray;
    }

    public void resetStartStream() {
        this.substream.copyFrom(this.stream);
        this.resetStartSubstream();
    }

    public void resetStartSubstream() {
        this.state_i = 24;
        this.substream.copyTo(this.state);
    }

    public void resetNextSubstream() {
        this.substream = this.substream.multiply(jumpW);
        this.resetStartSubstream();
    }

    public String formatState() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("The state of the ");
        stringBuffer.append(this.name == null ? "GenF2w2_32" : this.name);
        stringBuffer.append(" is : {");
        for (int i = 0; i < 24; ++i) {
            stringBuffer.append(this.state[(this.state_i + i) % 25] + ", ");
        }
        stringBuffer.append(this.state[(this.state_i + 25 - 1) % 25] + "}");
        return stringBuffer.toString();
    }

    protected double nextValue() {
        if (this.state_i < 0) {
            this.state_i = 24;
        }
        if (this.state_i + 7 < 25) {
            int n = this.state_i + 7;
            this.state[n] = this.state[n] ^ (BrmT1[(this.state[this.state_i] & 0xFFE00000) >>> 21] ^ BrmT2[(this.state[this.state_i] & 0x1FFC00) >>> 10] ^ BrmT3[this.state[this.state_i] & 0x3FF]);
        } else {
            int n = this.state_i + 7 - 25;
            this.state[n] = this.state[n] ^ (BrmT1[(this.state[this.state_i] & 0xFFE00000) >>> 21] ^ BrmT2[(this.state[this.state_i] & 0x1FFC00) >>> 10] ^ BrmT3[this.state[this.state_i] & 0x3FF]);
        }
        this.state[this.state_i] = Br1[(this.state[this.state_i] & 0xFFE00000) >>> 21] ^ Br2[(this.state[this.state_i] & 0x1FFC00) >>> 10] ^ Br3[this.state[this.state_i] & 0x3FF];
        long l = this.state[this.state_i--];
        return (double)(l <= 0L ? l + 0x100000000L : l) * 2.3283064359965952E-10;
    }

    static {
        GenF2w2_32.initTables();
        F2wPoly.F2w f2w = new F2wPoly.F2w(-95446209);
        polyBase = new F2wPoly(25, new F2wPoly.F2w.F2wElem[]{f2w.createElem(679131202), f2w.createElem(-425292512)}, new int[]{0, 7}, f2w);
        curr_stream = polyBase.createElem(new int[]{-1779282517, 191386133, -412300569, -1354841543, 1902095651, 614830253, 1776596463, -1085972159, -1766057093, -1480722395, -1042385481, -2007455287, 766015123, -1235748387, -2323825, -2128487823, -1954398517, -2007169547, 1310772551, 1520096729, 1361841155, -360350515, 1287770895, -2003720031, -1497912613});
        jumpW = polyBase.createZ().exponentiateBase2(300);
        jumpZ = jumpW.exponentiateBase2(200);
    }
}

