/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.GeometricDist;
import umontreal.iro.lecuyer.probdist.NegativeBinomialDist;
import umontreal.iro.lecuyer.randvar.NegativeBinomialGen;
import umontreal.iro.lecuyer.rng.RandomStream;

public class NegativeBinomialConvolutionGen
extends NegativeBinomialGen {
    private int n;
    private double p;

    public NegativeBinomialConvolutionGen(RandomStream randomStream, NegativeBinomialDist negativeBinomialDist) {
        super(randomStream, negativeBinomialDist);
        this.n = negativeBinomialDist.getN();
        this.p = negativeBinomialDist.getP();
    }

    public int nextInt() {
        int n = 0;
        for (int i = 0; i < this.n; ++i) {
            n += GeometricDist.inverseF(this.p, this.stream.nextDouble());
        }
        return n;
    }

    public static int nextInt(RandomStream randomStream, int n, double d) {
        return NegativeBinomialConvolutionGen.convolution(randomStream, n, d);
    }

    private static int convolution(RandomStream randomStream, int n, double d) {
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += GeometricDist.inverseF(d, randomStream.nextDouble());
        }
        return n2;
    }
}

