/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.randvar;

import umontreal.iro.lecuyer.probdist.LogarithmicDist;
import umontreal.iro.lecuyer.randvar.RandomVariateGenInt;
import umontreal.iro.lecuyer.rng.RandomStream;

public class LogarithmicGen
extends RandomVariateGenInt {
    private static final double default_theta_limit = 0.96;
    private double theta_limit = 0.96;
    private double theta;
    private double t;
    private double h;

    public LogarithmicGen(RandomStream randomStream, LogarithmicDist logarithmicDist) {
        super(randomStream, logarithmicDist);
        this.init();
    }

    public LogarithmicGen(RandomStream randomStream, LogarithmicDist logarithmicDist, double d) {
        super(randomStream, logarithmicDist);
        this.theta_limit = d;
        this.init();
    }

    private void init() {
        double d = ((LogarithmicDist)this.dist).getTheta();
        if (d >= this.theta_limit) {
            this.h = Math.log(1.0 - d);
        } else {
            this.t = -d / Math.log(1.0 - d);
        }
    }

    public int nextInt() {
        if (this.theta < this.theta_limit) {
            return LogarithmicGen.ls(this.stream, this.theta, this.t);
        }
        return LogarithmicGen.lk(this.stream, this.theta, this.h);
    }

    public static int nextInt(RandomStream randomStream, double d) {
        if (d < 0.96) {
            return LogarithmicGen.ls(randomStream, d, -d / Math.log(1.0 - d));
        }
        return LogarithmicGen.lk(randomStream, d, Math.log(1.0 - d));
    }

    private static int ls(RandomStream randomStream, double d, double d2) {
        double d3 = randomStream.nextDouble();
        int n = 1;
        for (double d4 = d2; d3 > d4; d3 -= d4, d4 *= d * ((double)(++n) - 1.0) / (double)n) {
        }
        return n;
    }

    private static int lk(RandomStream randomStream, double d, double d2) {
        double d3 = randomStream.nextDouble();
        if (d3 > d) {
            return 1;
        }
        double d4 = randomStream.nextDouble();
        double d5 = 1.0 - Math.exp(d4 * d2);
        if (d3 <= d5 * d5) {
            int n = (int)(1.0 + Math.log(d3) / Math.log(d5));
            return n;
        }
        return d3 > d5 ? 1 : 2;
    }
}

