/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class TruncatedDist
extends ContinuousDistribution {
    private ContinuousDistribution dist;
    private double fa;
    private double fb;
    private double fbfa;
    private double a;
    private double b;

    public TruncatedDist(ContinuousDistribution continuousDistribution, double d, double d2) {
        this.setParams(continuousDistribution, d, d2);
    }

    public double density(double d) {
        return this.dist.density(d) / this.fbfa;
    }

    public double cdf(double d) {
        if (d <= this.a) {
            return 0.0;
        }
        if (d >= this.b) {
            return 1.0;
        }
        return this.dist.cdf(d) / this.fbfa;
    }

    public double barF(double d) {
        if (d <= this.a) {
            return 1.0;
        }
        if (d >= this.b) {
            return 0.0;
        }
        return this.dist.barF(d) / this.fbfa;
    }

    public double inverseF(double d) {
        return this.dist.inverseF(this.fa + this.fbfa * d);
    }

    public double getA() {
        return this.a;
    }

    public double getB() {
        return this.b;
    }

    public double getFa() {
        return this.fa;
    }

    public double getFb() {
        return this.fb;
    }

    public double getArea() {
        return this.fbfa;
    }

    public void setParams(ContinuousDistribution continuousDistribution, double d, double d2) {
        this.dist = continuousDistribution;
        if (d >= d2) {
            throw new IllegalArgumentException("a must be smaller than b.");
        }
        this.a = d;
        this.fa = d == Double.NEGATIVE_INFINITY ? 0.0 : continuousDistribution.cdf(d);
        this.fb = d2 == Double.POSITIVE_INFINITY ? 1.0 : continuousDistribution.cdf(d2);
        this.fbfa = this.fb - this.fa;
    }
}

