/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class ParetoDist
extends ContinuousDistribution {
    private double alpha;
    private double beta;

    public ParetoDist(double d) {
        this.setParams(d, 1.0);
    }

    public ParetoDist(double d, double d2) {
        this.setParams(d, d2);
    }

    public double density(double d) {
        return ParetoDist.density(this.alpha, this.beta, d);
    }

    public double cdf(double d) {
        return ParetoDist.cdf(this.alpha, this.beta, d);
    }

    public double barF(double d) {
        return ParetoDist.barF(this.alpha, this.beta, d);
    }

    public double inverseF(double d) {
        return ParetoDist.inverseF(this.alpha, this.beta, d);
    }

    public static double density(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return d3 <= d2 ? 0.0 : d * Math.pow(d2, d) * Math.pow(d3, -(d + 1.0));
    }

    public static double cdf(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 < d2) {
            return 0.0;
        }
        if (d3 >= Double.MAX_VALUE) {
            return 1.0;
        }
        return 1.0 - Math.pow(d2 / d3, d);
    }

    public static double barF(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 < d2) {
            return 1.0;
        }
        return Math.pow(d2 / d3, d);
    }

    public static double inverseF(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("c <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (d3 <= 0.0) {
            return 1.0;
        }
        if (d3 >= 1.0 || -Math.log(1.0 - d3) / Math.log(10.0) >= d * 308.0) {
            throw new ArithmeticException("inverse function cannot be positive infinity");
        }
        return d2 / Math.pow(1.0 - d3, 1.0 / d);
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setParams(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        this.alpha = d;
        this.beta = d2;
    }
}

