/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.BinomialDist;
import umontreal.iro.lecuyer.probdist.DiscreteDistributionInt;
import umontreal.iro.lecuyer.util.Num;

public class NegativeBinomialDist
extends DiscreteDistributionInt {
    private int n;
    private double p;
    public static double MAXN = 100000.0;

    public NegativeBinomialDist(int n, double d) {
        this.setParams(n, d);
    }

    public double prob(int n) {
        if (n < 0) {
            return 0.0;
        }
        if (this.p == 0.0) {
            return 0.0;
        }
        if (this.p == 1.0) {
            if (n > 0) {
                return 0.0;
            }
            return 1.0;
        }
        if (this.pdf == null) {
            return NegativeBinomialDist.prob(this.n, this.p, n);
        }
        if (n > this.xmax || n < this.xmin) {
            return NegativeBinomialDist.prob(this.n, this.p, n);
        }
        return this.pdf[n - this.xmin];
    }

    public double cdf(int n) {
        if (this.p < 0.0 || this.p > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (n < 0) {
            return 0.0;
        }
        if (this.p >= 1.0) {
            return 1.0;
        }
        if (this.p <= 0.0) {
            return 0.0;
        }
        if (this.cdf != null) {
            if (n >= this.xmax) {
                return 1.0;
            }
            if (n < this.xmin) {
                return NegativeBinomialDist.cdf(this.n, this.p, n);
            }
            if (n <= this.xmed) {
                return this.cdf[n - this.xmin];
            }
            return 1.0 - this.cdf[n + 1 - this.xmin];
        }
        return NegativeBinomialDist.cdf(this.n, this.p, n);
    }

    public double barF(int n) {
        if (this.p < 0.0 || this.p > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (n < 1) {
            return 1.0;
        }
        if (this.p >= 1.0) {
            return 0.0;
        }
        if (this.p <= 0.0) {
            return 1.0;
        }
        if (this.cdf == null) {
            return BinomialDist.cdf(n - 1 + this.n, this.p, this.n - 1);
        }
        if (n > this.xmax) {
            return BinomialDist.cdf(n - 1 + this.n, this.p, this.n - 1);
        }
        if (n <= this.xmin) {
            return 1.0;
        }
        if (n > this.xmed) {
            return this.cdf[n - this.xmin];
        }
        return 1.0 - this.cdf[n - 1 - this.xmin];
    }

    public int inverseF(double d) {
        if (this.cdf == null) {
            return NegativeBinomialDist.inverseF(this.n, this.p, d);
        }
        return super.inverseF(d);
    }

    public static double prob(int n, double d, int n2) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("n < 1");
        }
        if (n2 < 0) {
            return 0.0;
        }
        if (d >= 1.0) {
            if (n2 == 0) {
                return 1.0;
            }
            return 0.0;
        }
        if (d <= 0.0) {
            return 0.0;
        }
        if (n2 <= 15 || n <= 15) {
            double d2 = Math.pow(d, n) * Num.combination(n + n2 - 1, n2) * Math.pow(1.0 - d, n2);
            return d2;
        }
        double d3 = (double)n2 * Math.log(1.0 - d) + (double)n * Math.log(d) + Num.lnFactorial(n + n2 - 1) - Num.lnFactorial(n - 1) - Num.lnFactorial(n2);
        if (d3 >= 709.0895657128241) {
            throw new IllegalArgumentException("term overflow");
        }
        if (d3 <= -708.3964185322641) {
            return 0.0;
        }
        return Math.exp(d3);
    }

    public static double cdf(int n, double d, int n2) {
        double d2 = DiscreteDistributionInt.EPSILON;
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("n < 1");
        }
        if (n2 < 0) {
            return 0.0;
        }
        if (d >= 1.0) {
            return 1.0;
        }
        if (d <= 0.0) {
            return 0.0;
        }
        int n3 = (int)(1.0 + ((double)n * (1.0 - d) - 1.0) / d);
        if (n3 > n2) {
            n3 = n2;
        }
        if (n3 <= 100000) {
            int n4;
            double d3;
            double d4 = d3 = NegativeBinomialDist.prob(n, d, n3);
            double d5 = d3;
            for (n4 = n3; n4 > 0 && !((d4 *= (double)n4 / ((1.0 - d) * (double)(n + n4 - 1))) < d2); --n4) {
                d5 += d4;
            }
            d4 = d3;
            for (n4 = n3; n4 < n2 && !((d4 *= (1.0 - d) * (double)(n + n4) / (double)(n4 + 1)) < d2); ++n4) {
                d5 += d4;
            }
            if (d5 <= 1.0) {
                return d5;
            }
            return 1.0;
        }
        return 1.0 - BinomialDist.cdf(n2 + n, d, n - 1);
    }

    public static int inverseF(int n, double d, double d2) {
        double d3;
        if (d2 < 0.0 || d2 >= 1.0) {
            throw new IllegalArgumentException("u is not in [0,1]");
        }
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("n < 1");
        }
        if (d >= 1.0) {
            return 0;
        }
        if (d <= 0.0) {
            return 0;
        }
        int n2 = 0;
        int n3 = (int)(1.0 + ((double)n * (1.0 - d) - 1.0) / d);
        double d4 = d3 = NegativeBinomialDist.prob(n, d, n3);
        double d5 = d3;
        for (int i = n3; i > 0 && !((d4 *= (double)i / ((1.0 - d) * (double)(n + i - 1))) < EPSILON); --i) {
            d5 += d4;
        }
        d4 = d3;
        n2 = n3;
        if (d5 < d2) {
            while (d5 < d2 && !((d4 *= (1.0 - d) * (double)(n + n2) / (double)(n2 + 1)) < EPSILON)) {
                d5 += d4;
                ++n2;
            }
        } else {
            while (d5 >= d2 && !((d4 *= (double)n2 / ((1.0 - d) * (double)(n + n2 - 1))) < EPSILON)) {
                d5 -= d4;
                --n2;
            }
            ++n2;
        }
        return n2;
    }

    public int getN() {
        return this.n;
    }

    public double getP() {
        return this.p;
    }

    public void setParams(int n, double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("p not in [0, 1]");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("n < 1");
        }
        this.n = n;
        this.p = d;
        int n2 = (int)(1.0 + ((double)n * (1.0 - d) - 1.0) / d);
        if (n2 < 0 || (double)n2 > MAXN) {
            this.pdf = null;
            this.cdf = null;
            return;
        }
        int n3 = (int)((double)n * (1.0 - d) / d + 16.0 * Math.sqrt((double)n * (1.0 - d) / (d * d)));
        if (n3 < 32) {
            n3 = 32;
        }
        double[] dArray = new double[1 + n3];
        double[] dArray2 = new double[1 + n3];
        double d2 = EPSILON / NegativeBinomialDist.prob(n, d, n2);
        dArray[n2] = 1.0;
        double d3 = 1.0;
        int n4 = n2;
        while (n4 > 0 && dArray[n4] >= d2) {
            dArray[n4 - 1] = dArray[n4] * (double)n4 / ((1.0 - d) * (double)(n + n4 - 1));
            d3 += dArray[--n4];
        }
        int n5 = n4;
        n4 = n2;
        while (dArray[n4] >= d2) {
            dArray[n4 + 1] = dArray[n4] * (1.0 - d) * (double)(n + n4) / (double)(n4 + 1);
            d3 += dArray[++n4];
            if (n4 != n3 - 1) continue;
            double[] dArray3 = new double[1 + (n3 *= 2)];
            System.arraycopy(dArray, 0, dArray3, 0, dArray.length);
            dArray = dArray3;
            dArray3 = new double[1 + n3];
            System.arraycopy(dArray2, 0, dArray3, 0, dArray2.length);
            dArray2 = dArray3;
        }
        int n6 = n4;
        n4 = n5;
        while (n4 <= n6) {
            int n7 = n4++;
            dArray[n7] = dArray[n7] / d3;
        }
        dArray2[n5] = dArray[n5];
        n4 = n5;
        while (n4 < n6 && dArray2[n4] < 0.5) {
            dArray2[++n4] = dArray2[n4 - 1] + dArray[n4];
        }
        this.xmed = n4;
        dArray2[n6] = dArray[n6];
        n4 = n6 - 1;
        do {
            dArray2[n4] = dArray[n4] + dArray2[n4 + 1];
        } while (--n4 > this.xmed);
        this.xmin = n5;
        this.xmax = n6;
        this.pdf = new double[n6 + 1 - n5];
        this.cdf = new double[n6 + 1 - n5];
        System.arraycopy(dArray, n5, this.pdf, 0, n6 + 1 - n5);
        System.arraycopy(dArray2, n5, this.cdf, 0, n6 + 1 - n5);
    }
}

