/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.NormalDist;

public class LognormalDist
extends ContinuousDistribution {
    private double mu;
    private double sigma;

    public LognormalDist() {
        this.setParams(0.0, 1.0);
    }

    public LognormalDist(double d, double d2) {
        this.setParams(d, d2);
    }

    public double density(double d) {
        return LognormalDist.density(this.mu, this.sigma, d);
    }

    public double cdf(double d) {
        return LognormalDist.cdf(this.mu, this.sigma, d);
    }

    public double barF(double d) {
        return LognormalDist.barF(this.mu, this.sigma, d);
    }

    public double inverseF(double d) {
        return LognormalDist.inverseF(this.mu, this.sigma, d);
    }

    public static double density(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        if (d3 <= 0.0) {
            return 0.0;
        }
        double d4 = Math.log(d3) - d;
        return Math.exp(-d4 * d4 / (2.0 * d2 * d2)) / (Math.sqrt(Math.PI * 2) * d2 * d3);
    }

    public static double cdf(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma  <= 0");
        }
        if (d3 <= 0.0) {
            return 0.0;
        }
        return NormalDist.cdf01((Math.log(d3) - d) / d2);
    }

    public static double barF(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma  <= 0");
        }
        if (d3 <= 0.0) {
            return 0.0;
        }
        return NormalDist.barF01((Math.log(d3) - d) / d2);
    }

    public static double inverseF(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma  <= 0");
        }
        if (d3 > 1.0 || d3 < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (2.220446049250313E-16 >= 1.0 - d3) {
            throw new ArithmeticException("inverse function cannot be positive infinity");
        }
        if (d3 <= 0.0) {
            return 0.0;
        }
        double d4 = NormalDist.inverseF01(d3);
        double d5 = d + d2 * d4;
        if (d4 >= 1000.0 || d5 >= 709.782712893384) {
            throw new ArithmeticException("inverse function cannot be positive infinity");
        }
        if (d4 <= -1000.0 || d5 <= -709.782712893384) {
            return 0.0;
        }
        return Math.exp(d5);
    }

    public double getMu() {
        return this.mu;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setParams(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        this.mu = d;
        this.sigma = d2;
    }
}

