/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class LaplaceDist
extends ContinuousDistribution {
    private double theta;
    private double phi;

    public LaplaceDist() {
        this.theta = 0.0;
        this.phi = 1.0;
    }

    public LaplaceDist(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("phi <= 0");
        }
        this.theta = d;
        this.phi = d2;
    }

    public double density(double d) {
        return LaplaceDist.density(this.theta, this.phi, d);
    }

    public double cdf(double d) {
        return LaplaceDist.cdf(this.theta, this.phi, d);
    }

    public double barF(double d) {
        return LaplaceDist.barF(this.theta, this.phi, d);
    }

    public double inverseF(double d) {
        return LaplaceDist.inverseF(this.theta, this.phi, d);
    }

    public static double density(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("phi <= 0");
        }
        return Math.exp(-Math.abs(d3 - d) / d2) / (2.0 * d2);
    }

    public static double cdf(double d, double d2, double d3) {
        if (d3 <= d) {
            return Math.exp((d3 - d) / d2) / 2.0;
        }
        return 1.0 - Math.exp((d - d3) / d2) / 2.0;
    }

    public static double barF(double d, double d2, double d3) {
        if (d3 <= d) {
            return 1.0 - Math.exp((d3 - d) / d2) / 2.0;
        }
        return Math.exp((d - d3) / d2) / 2.0;
    }

    public static double inverseF(double d, double d2, double d3) {
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException("u should be in [0,1]");
        }
        if (d3 <= 0.0) {
            throw new ArithmeticException("inverse function cannot be negative infinity");
        }
        if (d3 >= 1.0) {
            throw new ArithmeticException("inverse function cannot be positive infinity");
        }
        double d4 = d3 > 0.5 ? -Math.log(2.0 - 2.0 * d3) : Math.log(2.0 * d3);
        return d + d2 * d4;
    }

    public double getTheta() {
        return this.theta;
    }

    public double getPhi() {
        return this.phi;
    }
}

