/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.util.Num;

public class GammaDist
extends ContinuousDistribution {
    private double alpha;
    private double lambda;
    private double logFactor;

    public GammaDist(double d) {
        this.setParams(d, 1.0, this.decPrec);
    }

    public GammaDist(double d, double d2) {
        this.setParams(d, d2, this.decPrec);
    }

    public GammaDist(double d, double d2, int n) {
        this.setParams(d, d2, n);
    }

    public double density(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        double d2 = this.logFactor + (this.alpha - 1.0) * Math.log(d) - this.lambda * d;
        if (d2 > -1000.0) {
            return Math.exp(d2);
        }
        return 0.0;
    }

    public double cdf(double d) {
        return GammaDist.cdf(this.alpha, this.lambda, this.decPrec, d);
    }

    public double inverseF(double d) {
        return GammaDist.inverseF(this.alpha, this.decPrec, d) / this.lambda;
    }

    public static double density(double d, double d2, double d3) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d3 <= 0.0) {
            return 0.0;
        }
        double d4 = d * Math.log(d2 * d3) - d2 * d3 - Num.lnGamma(d);
        if (d4 > -1000.0) {
            return Math.exp(d4) / d3;
        }
        return 0.0;
    }

    public static double cdf(double d, double d2, int n, double d3) {
        return GammaDist.cdf(d, n, d2 * d3);
    }

    public static double cdf(double d, int n, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        if (d2 <= 0.0) {
            return 0.0;
        }
        if (d2 >= d * 1000.0) {
            return 1.0;
        }
        if (d >= 1.0E8) {
            return NormalDist.cdf01((d2 - d) / Math.sqrt(d));
        }
        double d3 = Math.exp(d * Math.log(d2) - d2 - Num.lnGamma(d));
        double d4 = EPSARRAY[n];
        if (d2 <= 1.0 || d2 < d) {
            double d5 = 1.0;
            double d6 = 1.0;
            double d7 = d;
            while ((d6 *= d2 / (d7 += 1.0)) >= d4 * (d5 += d6)) {
            }
            d5 = d5 * d3 / d;
            return d5;
        }
        return 1.0 - GammaDist.barF(d, n, d2);
    }

    public static double barF(double d, double d2, int n, double d3) {
        return GammaDist.barF(d, n, d2 * d3);
    }

    /*
     * Unable to fully structure code
     */
    public static double barF(double var0, int var2_1, double var3_2) {
        var5_3 = new double[6];
        var6_4 = GammaDist.EPSARRAY[var2_1];
        if (var0 <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (var2_1 <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        if (var3_2 <= 0.0) {
            return 1.0;
        }
        if (var3_2 >= var0 * 1000.0) {
            return 0.0;
        }
        if (var0 >= 1.0E8) {
            return NormalDist.barF01((var3_2 - var0) / Math.sqrt(var0));
        }
        var12_5 = Math.exp(var0 * Math.log(var3_2) - var3_2 - Num.lnGamma(var0));
        if (var3_2 <= 1.0 || var3_2 < var0) {
            return 1.0 - GammaDist.cdf(var0, var2_1, var3_2);
        }
        var16_6 = 1.0 - var0;
        var18_7 = var16_6 + var3_2 + 1.0;
        var22_8 = 0.0;
        var5_3[0] = 1.0;
        var5_3[1] = var3_2;
        var5_3[2] = var3_2 + 1.0;
        var5_3[3] = var3_2 * var18_7;
        var14_9 = var5_3[2] / var5_3[3];
        block0: while (true) {
            var5_3[4] = (var18_7 += 2.0) * var5_3[2] - (var16_6 += 1.0) * (var22_8 += 1.0) * var5_3[0];
            var5_3[5] = var18_7 * var5_3[3] - var16_6 * var22_8 * var5_3[1];
            if (var5_3[5] != 0.0) {
                var20_10 = var5_3[4] / var5_3[5];
                var24_11 = Math.abs(var14_9 - var20_10);
                if (var24_11 <= var6_4 * var20_10) {
                    return var12_5 * var14_9;
                }
                var14_9 = var20_10;
            }
            for (var26_12 = 0; var26_12 < 4; ++var26_12) {
                var5_3[var26_12] = var5_3[var26_12 + 2];
            }
            if (!(Math.abs(var5_3[4]) >= 1.0E30)) continue;
            var26_12 = 0;
            while (true) {
                if (var26_12 < 4) ** break;
                continue block0;
                v0 = var26_12++;
                var5_3[v0] = var5_3[v0] / 1.0E30;
            }
            break;
        }
    }

    public static double inverseF(double d, double d2, int n, double d3) {
        return GammaDist.inverseF(d, n, d3) / d2;
    }

    public static double inverseF(double d, int n, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        if (d2 > 1.0 || d2 < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (d2 <= 0.0) {
            return 0.0;
        }
        if (d2 >= 1.0) {
            throw new ArithmeticException("inverse function cannot be positive infinity");
        }
        d2 = 1.0 - d2;
        double d3 = Double.MAX_VALUE;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 1.0;
        double d7 = 5.551115123125783E-16;
        double d8 = 1.0 / (9.0 * d);
        double d9 = 1.0 - d8 - NormalDist.inverseF01(d2) * Math.sqrt(d8);
        double d10 = d * d9 * d9 * d9;
        double d11 = Num.lnGamma(d);
        boolean bl = false;
        block0: while (true) {
            int n2;
            if (bl) {
                bl = false;
                d8 = 0.0625;
                if (d3 == Double.MAX_VALUE) {
                    if (d10 <= 0.0) {
                        d10 = 1.0;
                    }
                    while (d3 == Double.MAX_VALUE) {
                        d9 = GammaDist.barF(d, n, d10 = (1.0 + d8) * d10);
                        if (d9 < d2) {
                            d3 = d10;
                            d4 = d9;
                            break;
                        }
                        d8 += d8;
                    }
                }
                d8 = 0.5;
                int n3 = 0;
                for (n2 = 0; n2 < 400; ++n2) {
                    d10 = d5 + d8 * (d3 - d5);
                    d9 = GammaDist.barF(d, n, d10);
                    d11 = (d3 - d5) / (d5 + d3);
                    if (Math.abs(d11) < d7 || Math.abs(d11 = (d9 - d2) / d2) < d7 || d10 <= 0.0) break;
                    if (d9 >= d2) {
                        d5 = d10;
                        d6 = d9;
                        if (n3 < 0) {
                            n3 = 0;
                            d8 = 0.5;
                        } else {
                            d8 = n3 > 1 ? 0.5 * d8 + 0.5 : (d2 - d4) / (d6 - d4);
                        }
                        ++n3;
                        continue;
                    }
                    d3 = d10;
                    d4 = d9;
                    if (n3 > 0) {
                        n3 = 0;
                        d8 = 0.5;
                    } else {
                        d8 = n3 < -1 ? 0.5 * d8 : (d2 - d4) / (d6 - d4);
                    }
                    --n3;
                }
                if (d10 == 0.0) {
                    System.err.println("GammaDist.inverseF: underflow");
                }
                return d10;
            }
            for (n2 = 0; n2 < 13; ++n2) {
                if (d10 > d3 || d10 < d5) {
                    bl = true;
                    continue block0;
                }
                d9 = GammaDist.barF(d, n, d10);
                if (d9 < d4 || d9 > d6) {
                    bl = true;
                    continue block0;
                }
                if (d9 < d2) {
                    d3 = d10;
                    d4 = d9;
                } else {
                    d5 = d10;
                    d6 = d9;
                }
                d8 = (d - 1.0) * Math.log(d10) - d10 - d11;
                if (d8 < -709.782712893384) {
                    bl = true;
                    continue block0;
                }
                d8 = -Math.exp(d8);
                if (Math.abs((d8 = (d9 - d2) / d8) / d10) < (double)1.110223E-16f) {
                    return d10;
                }
                d10 -= d8;
            }
            break;
        }
        return d10;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setParams(double d, double d2, int n) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        this.alpha = d;
        this.lambda = d2;
        this.decPrec = n;
        this.logFactor = d * Math.log(d2) - Num.lnGamma(d);
        this.xa0 = 0.0;
    }
}

