/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class ExtremeValueDist
extends ContinuousDistribution {
    private double alpha;
    private double lambda;

    public ExtremeValueDist() {
        this.setParams(0.0, 1.0);
    }

    public ExtremeValueDist(double d, double d2) {
        this.setParams(d, d2);
    }

    public double density(double d) {
        return ExtremeValueDist.density(this.alpha, this.lambda, d);
    }

    public double cdf(double d) {
        return ExtremeValueDist.cdf(this.alpha, this.lambda, d);
    }

    public double barF(double d) {
        return ExtremeValueDist.barF(this.alpha, this.lambda, d);
    }

    public double inverseF(double d) {
        return ExtremeValueDist.inverseF(this.alpha, this.lambda, d);
    }

    public static double density(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("sigma <= 0");
        }
        return d2 * Math.exp(-Math.exp(-d2 * (d3 - d)) - d2 * (d3 - d));
    }

    public static double cdf(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d3 <= d - 1000.0 / d2) {
            return 0.0;
        }
        if (d3 >= d + 1000.0 / d2) {
            return 1.0;
        }
        return Math.exp(-Math.exp(-d2 * (d3 - d)));
    }

    public static double barF(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d3 <= d - 1000.0 / d2) {
            return 1.0;
        }
        if (d3 >= d + 1000.0 / d2) {
            return 0.0;
        }
        return 1.0 - Math.exp(-Math.exp(-d2 * (d3 - d)));
    }

    public static double inverseF(double d, double d2, double d3) {
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d3 >= 1.0) {
            return d + 1000.0 / d2;
        }
        if (d3 <= 0.0) {
            return d - 1000.0 / d2;
        }
        return -Math.log(-Math.log(d3)) / d2 + d;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setParams(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        this.alpha = d;
        this.lambda = d2;
    }
}

