/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class ExponentialDist
extends ContinuousDistribution {
    private double lambda;

    public ExponentialDist() {
        this.setLambda(1.0);
    }

    public ExponentialDist(double d) {
        this.setLambda(d);
    }

    public double density(double d) {
        return ExponentialDist.density(this.lambda, d);
    }

    public double cdf(double d) {
        return ExponentialDist.cdf(this.lambda, d);
    }

    public double barF(double d) {
        return ExponentialDist.barF(this.lambda, d);
    }

    public double inverseF(double d) {
        return ExponentialDist.inverseF(this.lambda, d);
    }

    public static double density(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        return d2 < 0.0 ? 0.0 : d * Math.exp(-d * d2);
    }

    public static double cdf(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            return 0.0;
        }
        if (d * d2 >= 1000.0) {
            return 1.0;
        }
        return 1.0 - Math.exp(-d * d2);
    }

    public static double barF(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 <= 0.0) {
            return 1.0;
        }
        if (d * d2 >= 1000.0) {
            return 0.0;
        }
        return Math.exp(-d * d2);
    }

    public static double inverseF(double d, double d2) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        if (d2 < 0.0 || d2 > 1.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (d2 >= 1.0) {
            return 1000.0 / d;
        }
        if (d2 <= 0.0) {
            return 0.0;
        }
        return -Math.log(1.0 - d2) / d;
    }

    public double getLambda() {
        return this.lambda;
    }

    public void setLambda(double d) {
        if (d <= 0.0) {
            throw new IllegalArgumentException("lambda <= 0");
        }
        this.lambda = d;
    }
}

