/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.GammaDist;

public class ErlangDist
extends ContinuousDistribution {
    private GammaDist dist;

    public ErlangDist(int n) {
        this.dist = new GammaDist(n);
    }

    public ErlangDist(int n, double d) {
        this.dist = new GammaDist(n, d);
    }

    public double density(double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        return this.dist.density(d);
    }

    public double cdf(double d) {
        return this.dist.cdf(d);
    }

    public static double density(int n, double d, double d2) {
        return GammaDist.density(n, d, d2);
    }

    public static double cdf(int n, double d, int n2, double d2) {
        return GammaDist.cdf(n, n2, d * d2);
    }

    public static double barF(int n, double d, int n2, double d2) {
        return GammaDist.barF(n, n2, d * d2);
    }

    public static double inverseF(int n, double d, int n2, double d2) {
        return GammaDist.inverseF(n, d, n2, d2);
    }

    public int getK() {
        return (int)this.dist.getAlpha();
    }

    public double getLambda() {
        return this.dist.getLambda();
    }

    public void setParams(int n, double d, int n2) {
        this.dist.setParams(n, d, n2);
    }
}

