/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Arrays;
import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class ContinuousEmpiricalDist
extends ContinuousDistribution {
    private double[] sortedObs;
    private double[] diffObs;
    private int n;
    private double sampleMean;
    private double sampleVariance;
    private double sampleStandardDeviation;

    public ContinuousEmpiricalDist(double[] dArray) {
        if (dArray.length <= 1) {
            throw new IllegalArgumentException("Two or more observations are needed");
        }
        this.sortedObs = dArray;
        this.init();
    }

    public ContinuousEmpiricalDist(InputStreamReader inputStreamReader) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        double[] dArray = new double[5];
        int n = 0;
        String string = bufferedReader.readLine();
        while (string != null) {
            int n2 = 0;
            while (string.charAt(n2) == '+' || string.charAt(n2) == '-' || Character.isDigit(string.charAt(n2))) {
                ++n2;
            }
            if (!(string = string.substring(0, n2)).equals("")) {
                try {
                    dArray[n++] = Double.parseDouble(string);
                    if (n >= dArray.length) {
                        double[] dArray2 = new double[2 * n];
                        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
                        dArray = dArray2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            string = bufferedReader.readLine();
        }
        this.sortedObs = new double[n];
        System.arraycopy(dArray, 0, this.sortedObs, 0, n);
        this.init();
    }

    public double density(double d) {
        if (d < this.sortedObs[0] || d >= this.sortedObs[this.n - 1]) {
            return 0.0;
        }
        for (int i = 0; i < this.n - 1; ++i) {
            if (!(d >= this.sortedObs[i]) || !(d < this.sortedObs[i + 1])) continue;
            return 1.0 / ((double)(this.n - 1) * this.diffObs[i]);
        }
        throw new IllegalStateException();
    }

    public double cdf(double d) {
        if (d <= this.sortedObs[0]) {
            return 0.0;
        }
        if (d >= this.sortedObs[this.n - 1]) {
            return 1.0;
        }
        for (int i = 0; i < this.n - 1; ++i) {
            if (!(d >= this.sortedObs[i]) || !(d < this.sortedObs[i + 1])) continue;
            return (double)i / ((double)this.n - 1.0) + (d - this.sortedObs[i]) / (((double)this.n - 1.0) * this.diffObs[i]);
        }
        throw new IllegalStateException();
    }

    public double barF(double d) {
        if (d <= this.sortedObs[0]) {
            return 1.0;
        }
        if (d >= this.sortedObs[this.n - 1]) {
            return 0.0;
        }
        for (int i = 0; i < this.n - 1; ++i) {
            if (!(d >= this.sortedObs[i]) || !(d < this.sortedObs[i + 1])) continue;
            return ((double)this.n - 1.0 - (double)i) / ((double)this.n - 1.0) - (d - this.sortedObs[i]) / (((double)this.n - 1.0) * this.diffObs[i]);
        }
        throw new IllegalStateException();
    }

    public double inverseF(double d) {
        if (d < 0.0 || d > 1.0) {
            throw new IllegalArgumentException("u is not in [0,1]");
        }
        double d2 = (double)(this.n - 1) * d;
        int n = (int)Math.floor(d2);
        if (n == this.n - 1) {
            return this.sortedObs[this.n - 1];
        }
        return this.sortedObs[n] + (d2 - (double)n) * this.diffObs[n];
    }

    private void init() {
        int n;
        Arrays.sort(this.sortedObs);
        this.n = this.sortedObs.length;
        this.diffObs = new double[this.sortedObs.length - 1];
        double d = 0.0;
        for (n = 0; n < this.diffObs.length; ++n) {
            this.diffObs[n] = this.sortedObs[n + 1] - this.sortedObs[n];
            d += this.sortedObs[n];
        }
        this.sampleMean = (d += this.sortedObs[this.n - 1]) / (double)this.n;
        d = 0.0;
        for (n = 0; n < this.n; ++n) {
            double d2 = this.sortedObs[n] - this.sampleMean;
            d += d2 * d2;
        }
        this.sampleVariance = d / (double)(this.n - 1);
        this.sampleStandardDeviation = Math.sqrt(this.sampleVariance);
    }

    public int getN() {
        return this.n;
    }

    public double getObs(int n) {
        return this.sortedObs[n];
    }

    public double getSampleMean() {
        return this.sampleMean;
    }

    public double getSampleVariance() {
        return this.sampleVariance;
    }

    public double getSampleStandardDeviation() {
        return this.sampleStandardDeviation;
    }
}

