/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.Distribution;

public abstract class ContinuousDistribution
implements Distribution {
    public int decPrec = 15;
    protected static final double XINF = Double.MAX_VALUE;
    protected double xa0 = -8.0;
    protected double xb0 = 8.0;
    protected static final double XBIG = 1000.0;
    protected static final double[] EPSARRAY = new double[]{0.5, 0.05, 0.005, 5.0E-4, 5.0E-5, 5.0E-6, 5.0E-7, 5.0E-8, 5.0E-9, 5.0E-10, 5.0E-11, 5.0E-12, 5.0E-13, 5.0E-14, 5.0E-15, 5.0E-16, 5.0E-17, 5.0E-18, 5.0E-19, 5.0E-20, 5.0E-21, 5.0E-22, 5.0E-23, 5.0E-24, 5.0E-25, 5.0E-26, 5.0E-27, 5.0E-28, 5.0E-29, 5.0E-30, 5.0E-31, 5.0E-32, 5.0E-33, 5.0E-34, 5.0E-35, 5.0E-36};

    public abstract double density(double var1);

    public double barF(double d) {
        return 1.0 - this.cdf(d);
    }

    private int getDecPrec() {
        return this.decPrec;
    }

    public double inverseF(double d) {
        double d2;
        double d3 = EPSARRAY[this.decPrec];
        double d4 = 0.0;
        if (d > 1.0 || d < 0.0) {
            throw new IllegalArgumentException("u not in [0, 1]");
        }
        if (this.decPrec > 15) {
            throw new IllegalArgumentException("decPrec too large");
        }
        if (this.decPrec <= 0) {
            throw new IllegalArgumentException("decPrec <= 0");
        }
        if (d <= 0.0) {
            d4 = -1.7976931348623157E308;
            return d4;
        }
        if (d >= 1.0) {
            d4 = Double.MAX_VALUE;
            return d4;
        }
        double d5 = this.xb0;
        double d6 = this.xa0;
        double d7 = this.cdf(d5);
        if (d7 < (d2 = this.cdf(d6))) {
            throw new IllegalArgumentException("F is decreasing");
        }
        while (d7 < d && d5 < 8.988465674311579E307) {
            d6 = d5;
            d2 = d7;
            d7 = this.cdf(d5 *= 2.0);
        }
        while (d2 > d && d6 > -8.988465674311579E307) {
            d5 = d6;
            d7 = d2;
            d2 = this.cdf(d6 *= 2.0);
        }
        d7 -= d;
        d2 -= d;
        boolean bl = false;
        int n = 0;
        while (!bl) {
            d4 = (d6 + d5) / 2.0;
            double d8 = this.cdf(d4) - d;
            if (Math.abs(d8) <= d3 || Math.abs((d5 - d6) / (d4 + 2.220446049250313E-16)) <= d3) {
                bl = true;
            } else if (d8 * d2 < 0.0) {
                d5 = d4;
            } else {
                d6 = d4;
            }
            if (++n <= 100) continue;
            bl = true;
        }
        return d4;
    }
}

