/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;
import umontreal.iro.lecuyer.probdist.GammaDist;
import umontreal.iro.lecuyer.probdist.NormalDist;
import umontreal.iro.lecuyer.util.Num;

public class ChiSquareDist
extends ContinuousDistribution {
    protected int n;

    public ChiSquareDist(int n) {
        this.setN(n);
    }

    public double density(double d) {
        return ChiSquareDist.density(this.n, d);
    }

    public double cdf(double d) {
        return ChiSquareDist.cdf(this.n, this.decPrec, d);
    }

    public double barF(double d) {
        return ChiSquareDist.barF(this.n, this.decPrec, d);
    }

    public double inverseF(double d) {
        return ChiSquareDist.inverseF(this.n, d);
    }

    public static double density(int n, double d) {
        if (d <= 0.0) {
            return 0.0;
        }
        return Math.exp(((double)n / 2.0 - 1.0) * Math.log(d) - d / 2.0 - (double)n / 2.0 * 0.6931471805599453 - Num.lnGamma((double)n / 2.0));
    }

    public static double cdf(int n, int n2, double d) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (d <= 0.0) {
            return 0.0;
        }
        if (d >= 1000.0 * (double)n) {
            return 0.9999999999999998;
        }
        if (n <= 350) {
            double d2;
            double d3 = d / 2.0;
            if ((n & 1) == 0) {
                double d4;
                d2 = d4 = Math.exp(-d3);
                for (int i = 1; i < n / 2; ++i) {
                    d4 = d4 * d3 / (double)i;
                    d2 += d4;
                }
                d2 = 1.0 - d2;
            } else {
                double d5 = -1.0 + 2.0 * NormalDist.cdf01(Math.sqrt(d));
                if (n == 1) {
                    return d5;
                }
                double d6 = Math.exp(-d3);
                double d7 = Math.sqrt(d3) * d6 / 0.8862269254527579;
                double d8 = d5;
                for (int i = 3; i < n; i += 2) {
                    d8 -= d7;
                    d7 = d7 * d3 * 2.0 / (double)i;
                }
                d2 = d8 - d7;
            }
            if (d2 < 0.0) {
                return 0.0;
            }
            return d2;
        }
        return GammaDist.cdf((double)n / 2.0, n2, d / 2.0);
    }

    public static double barF(int n, int n2, double d) {
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (d <= 0.0) {
            return 1.0;
        }
        if (d >= 1000.0 * (double)n) {
            return 0.0;
        }
        if (n <= 350) {
            double d2;
            double d3 = d / 2.0;
            if ((n & 1) == 0) {
                double d4;
                d2 = d4 = Math.exp(-d3);
                for (int i = 1; i < n / 2; ++i) {
                    d4 = d4 * d3 / (double)i;
                    d2 += d4;
                }
            } else {
                double d5 = 2.0 * NormalDist.barF01(Math.sqrt(d));
                if (n == 1) {
                    return d5;
                }
                double d6 = Math.exp(-d3);
                double d7 = Math.sqrt(d3) * d6 / 0.8862269254527579;
                for (int i = 3; i < n; i += 2) {
                    d5 += d7;
                    d7 = d7 * d3 * 2.0 / (double)i;
                }
                d2 = d5 + d7;
            }
            if (d2 >= 1.0) {
                return 1.0;
            }
            return d2;
        }
        return GammaDist.barF((double)n / 2.0, n2, d / 2.0);
    }

    public static double inverseF(int n, double d) {
        double d2;
        double d3;
        double d4;
        if (n <= 0) {
            throw new IllegalArgumentException("n <= 0");
        }
        if (d < 1.0E-5 || d > 0.99999) {
            return 2.0 * GammaDist.inverseF((double)n / 2.0, 7, d);
        }
        if (d >= 1.0) {
            return (double)n * 1000.0;
        }
        if (d >= 0.999998) {
            return (double)n + 4.0 * Math.sqrt(2.0 * (double)n);
        }
        double d5 = Num.lnGamma((double)n / 2.0);
        double d6 = 0.5 * (double)n;
        double d7 = d6 - 1.0;
        if ((double)n >= -1.24 * Math.log(d)) {
            double d8 = NormalDist.inverseF01(d);
            d3 = d8 * Math.sqrt(d4 = 0.222222 / (double)n) + 1.0 - d4;
            d2 = (double)n * d3 * d3 * d3;
            if (d2 > 2.2 * (double)n + 6.0) {
                d2 = -2.0 * (Math.log(1.0 - d) - d7 * Math.log(0.5 * d2) + d5);
            }
        } else {
            d2 = Math.pow(d * d6 * Math.exp(d5 + d6 * 0.6931471805), 1.0 / d6);
            if (d2 - 5.0E-6 < 0.0) {
                return d2;
            }
        }
        d3 = d2;
        d4 = 0.5 * d2;
        double d9 = d - GammaDist.cdf(d6, 5, d4);
        if (GammaDist.cdf(d6, 5, d4) == -1.0) {
            throw new IllegalArgumentException("RESULT = -1");
        }
        double d10 = d9 * Math.exp(d6 * 0.6931471805 + d5 + d4 - d7 * Math.log(d2));
        double d11 = d10 / d2;
        double d12 = 0.5 * d10 - d11 * d7;
        double d13 = (210.0 + d12 * (140.0 + d12 * (105.0 + d12 * (84.0 + d12 * (70.0 + 60.0 * d12))))) / 420.0;
        double d14 = (420.0 + d12 * (735.0 + d12 * (966.0 + d12 * (1141.0 + 1278.0 * d12)))) / 2520.0;
        double d15 = (210.0 + d12 * (462.0 + d12 * (707.0 + 932.0 * d12))) / 2520.0;
        double d16 = (252.0 + d12 * (672.0 + 1182.0 * d12) + d7 * (294.0 + d12 * (889.0 + 1740.0 * d12))) / 5040.0;
        double d17 = (84.0 + 264.0 * d12 + d7 * (175.0 + 606.0 * d12)) / 2520.0;
        double d18 = (120.0 + d7 * (346.0 + 127.0 * d7)) / 5040.0;
        d2 += d10 * (1.0 + 0.5 * d10 * d13 - d11 * d7 * (d13 - d11 * (d14 - d11 * (d15 - d11 * (d16 - d11 * (d17 - d11 * d18))))));
        while (Math.abs(d3 / d2 - 1.0) > 5.0E-6) {
            d3 = d2;
            d4 = 0.5 * d2;
            double d19 = GammaDist.cdf(d6, 6, d4);
            d9 = d - d19;
            if (d19 == -1.0) {
                return -1.0;
            }
            d10 = d9 * Math.exp(d6 * 0.6931471805 + d5 + d4 - d7 * Math.log(d2));
            d11 = d10 / d2;
            d12 = 0.5 * d10 - d11 * d7;
            d13 = (210.0 + d12 * (140.0 + d12 * (105.0 + d12 * (84.0 + d12 * (70.0 + 60.0 * d12))))) / 420.0;
            d14 = (420.0 + d12 * (735.0 + d12 * (966.0 + d12 * (1141.0 + 1278.0 * d12)))) / 2520.0;
            d15 = (210.0 + d12 * (462.0 + d12 * (707.0 + 932.0 * d12))) / 2520.0;
            d16 = (252.0 + d12 * (672.0 + 1182.0 * d12) + d7 * (294.0 + d12 * (889.0 + 1740.0 * d12))) / 5040.0;
            d17 = (84.0 + 264.0 * d12 + d7 * (175.0 + 606.0 * d12)) / 2520.0;
            d18 = (120.0 + d7 * (346.0 + 127.0 * d7)) / 5040.0;
            d2 += d10 * (1.0 + 0.5 * d10 * d13 - d11 * d7 * (d13 - d11 * (d14 - d11 * (d15 - d11 * (d16 - d11 * (d17 - d11 * d18))))));
        }
        return d2;
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("degrees of freedom must be non-null and positive.");
        }
        this.n = n;
    }
}

