/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.ContinuousDistribution;

public class CauchyDist
extends ContinuousDistribution {
    private double alpha;
    private double beta;

    public CauchyDist() {
        this.setParams(0.0, 1.0);
    }

    public CauchyDist(double d, double d2) {
        this.setParams(d, d2);
    }

    public double density(double d) {
        return CauchyDist.density(this.alpha, this.beta, d);
    }

    public double cdf(double d) {
        return CauchyDist.cdf(this.alpha, this.beta, d);
    }

    public double barF(double d) {
        return CauchyDist.barF(this.alpha, this.beta, d);
    }

    public double inverseF(double d) {
        return CauchyDist.inverseF(this.alpha, this.beta, d);
    }

    public static double density(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        double d4 = (d3 - d) / d2;
        return 1.0 / (d2 * Math.PI * (1.0 + d4 * d4));
    }

    public static double cdf(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return Math.atan((d3 - d) / d2) / Math.PI + 0.5;
    }

    public static double barF(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        return 0.5 - Math.atan((d3 - d) / d2) / Math.PI;
    }

    public static double inverseF(double d, double d2, double d3) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        if (d3 < 0.0 || d3 > 1.0) {
            throw new IllegalArgumentException("u must be in [0,1]");
        }
        if (d3 <= 0.0) {
            throw new ArithmeticException("inverse function cannot be negative infinite");
        }
        if (d3 >= 1.0) {
            throw new ArithmeticException("inverse function cannot be positive infinite");
        }
        return d + Math.tan(Math.PI * (d3 - 0.5)) * d2;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public double getBeta() {
        return this.beta;
    }

    public void setParams(double d, double d2) {
        if (d2 <= 0.0) {
            throw new IllegalArgumentException("beta <= 0");
        }
        this.alpha = d;
        this.beta = d2;
    }
}

