/*
 * Decompiled with CFR 0.152.
 */
package umontreal.iro.lecuyer.probdist;

import umontreal.iro.lecuyer.probdist.BetaDist;
import umontreal.iro.lecuyer.util.Num;

public class BetaSymmetricalDist
extends BetaDist {
    private static final double PI_2 = 1.5707963267948966;
    private static final int MAXI = 10;
    private static final int MAXJ = 100;
    private static final double EPSBETA = 5.0E-11;
    private double p4a;

    public BetaSymmetricalDist(double d) {
        super(d, d);
        this.p4a = Math.pow(4.0, 1.0 - d);
    }

    public BetaSymmetricalDist(double d, int n) {
        super(d, d, n);
        this.p4a = Math.pow(4.0, 1.0 - d);
    }

    public double cdf(double d) {
        return BetaSymmetricalDist.cdf(this.alpha, this.beta, this.decPrec, d);
    }

    public double inverseF(double d) {
        return BetaSymmetricalDist.calcInverseF(this.alpha, this.decPrec, d, this.factor, this.p4a);
    }

    public static double density(double d, double d2) {
        return BetaSymmetricalDist.density(d, d, 0.0, 1.0, d2);
    }

    public static double cdf(double d, int n, double d2) {
        return BetaSymmetricalDist.cdf(d, d, n, d2);
    }

    public static double barF(double d, int n, double d2) {
        return 1.0 - BetaSymmetricalDist.cdf(d, d, n, d2);
    }

    public static double inverseF(double d, double d2) {
        return BetaSymmetricalDist.calcInverseF(d, 12, d2, 0.0, 0.0);
    }

    private static double inverseN1(double d, double d2) {
        double d3;
        double d4 = EPSARRAY[15];
        double d5 = Math.pow(d2 * d, 1.0 / d);
        double d6 = d * (1.0 - d) * d5 / (1.0 + d);
        if (d6 < d4) {
            return d5;
        }
        d5 = d2 * d / (1.0 + d6);
        double d7 = Math.pow(d5, 1.0 / d);
        int n = 0;
        do {
            ++n;
            d5 = d7;
            double d8 = 1.0;
            double d9 = 1.0;
            d3 = 1.0 / d;
            int n2 = 1;
            while ((d6 = (d8 *= ((double)n2 - d) / (double)n2) * (d9 *= d5) / ((double)n2 + d)) > (d3 += d6) * d4 && ++n2 < 100) {
            }
        } while (Math.abs((d7 = d5 - (d6 = ((d3 *= Math.pow(d5, d)) - d2) * Math.pow(d5 * (1.0 - d5), 1.0 - d))) - d5) > d4 && Math.abs(d6) > d3 * d4 && n <= 10);
        return d7;
    }

    private static double inverseN2(double d, double d2) {
        double d3;
        double d4 = (1.0 - d) * d2 * d2 * 4.0 / 3.0;
        double d5 = EPSARRAY[15];
        if (d4 < d5) {
            return 0.5 - d2;
        }
        double d6 = d2 / (1.0 + d4);
        int n = 0;
        do {
            ++n;
            d3 = d6;
            double d7 = 1.0;
            double d8 = 1.0;
            double d9 = 1.0;
            int n2 = 1;
            while ((d4 = (d9 *= ((double)n2 - d) / (double)n2) * (d8 *= 4.0 * d3 * d3) / (double)(2 * n2 + 1)) > (d7 += d4) * d5 && ++n2 < 100) {
            }
        } while (Math.abs((d6 = d3 - ((d7 *= d3) - d2) * Math.pow(1.0 - 4.0 * d3 * d3, 1.0 - d)) - d3) > d5 && n <= 10);
        return 0.5 - d6;
    }

    private static double calcInverseF(double d, int n, double d2, double d3, double d4) {
        double d5;
        double d6;
        boolean bl;
        if (d > 1.0) {
            return BetaSymmetricalDist.inverseF(d, d, n, d2);
        }
        if (d <= 0.0) {
            throw new IllegalArgumentException("alpha <= 0");
        }
        if (n <= 0) {
            throw new IllegalArgumentException("d <= 0");
        }
        if (d2 > 1.0 || d2 < 0.0) {
            throw new IllegalArgumentException("u not in [0,1]");
        }
        if (d2 == 0.0) {
            return 0.0;
        }
        if (d2 == 1.0) {
            return 1.0;
        }
        if (d2 == 0.5) {
            return 0.5;
        }
        if (d == 1.0) {
            return d2;
        }
        if (d == 0.5) {
            double d7 = Math.sin(d2 * 1.5707963267948966);
            return d7 * d7;
        }
        if (d2 > 0.5) {
            bl = true;
            d2 = 1.0 - d2;
        } else {
            bl = false;
        }
        if (d3 <= 0.0) {
            if (d > 5.0E-11) {
                double d8 = Num.lnGamma(d);
                d6 = 2.0 * d8 - Num.lnGamma(2.0 * d);
                d6 = Math.exp(d6);
            } else {
                d6 = 2.0 / d;
            }
        } else {
            d6 = 1.0 / d3;
        }
        if (d4 <= 0.0) {
            d4 = Math.pow(4.0, 1.0 - d);
        }
        double d9 = (d5 = d6 * (0.5 - d2) / d4) > 0.25 ? BetaSymmetricalDist.inverseN1(d, d6 * d2) : BetaSymmetricalDist.inverseN2(d, d5);
        if (bl) {
            return 1.0 - d9;
        }
        return d9;
    }
}

