/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.io.InputStream;
import java.net.URL;

public class ThreeD
extends Applet
implements Runnable {
    Model3D md;
    boolean painted = true;
    double xfac;
    int prevx;
    int prevy;
    double xtheta;
    double ytheta;
    Matrix3D amat = new Matrix3D();
    Matrix3D tmat = new Matrix3D();
    String mdname = null;
    String message = null;

    @Override
    public void init() {
        this.mdname = this.getParameter("model");
        this.amat.yrot(20.0);
        this.amat.xrot(110.0);
        if (this.mdname == null) {
            this.mdname = "model.txt";
        }
        this.resize(this.getSize().width <= 20 ? 400 : this.getSize().width, this.getSize().height <= 20 ? 400 : this.getSize().height);
    }

    @Override
    public void run() {
        InputStream inputStream = null;
        try {
            double d;
            double d2;
            Model3D model3D;
            Thread.currentThread().setPriority(1);
            inputStream = new URL(this.getDocumentBase(), this.mdname).openStream();
            this.md = model3D = new Model3D(inputStream);
            model3D.findBB();
            model3D.compress();
            double d3 = model3D.xmax - model3D.xmin;
            double d4 = model3D.ymax - model3D.ymin;
            double d5 = model3D.zmax - model3D.zmin;
            if (d4 > d3) {
                d3 = d4;
            }
            if (d5 > d3) {
                d3 = d5;
            }
            this.xfac = 0.7 * ((d2 = (double)this.getSize().width / d3) < (d = (double)this.getSize().height / d3) ? d2 : d);
        }
        catch (Exception exception) {
            this.md = null;
            this.message = exception.toString();
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.repaint();
    }

    @Override
    public void start() {
        if (this.md == null && this.message == null) {
            new Thread(this).start();
        }
    }

    @Override
    public void stop() {
    }

    @Override
    public boolean mouseDown(Event event, int n, int n2) {
        this.prevx = n;
        this.prevy = n2;
        return true;
    }

    @Override
    public boolean mouseDrag(Event event, int n, int n2) {
        this.tmat.unit();
        double d = (this.prevy - n2) * 360 / this.getSize().width;
        double d2 = (n - this.prevx) * 360 / this.getSize().height;
        this.tmat.xrot(d);
        this.tmat.yrot(d2);
        this.amat.mult(this.tmat);
        if (this.painted) {
            this.painted = false;
            this.repaint();
        }
        this.prevx = n;
        this.prevy = n2;
        return true;
    }

    @Override
    public void paint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.md != null) {
            this.md.mat.unit();
            this.md.mat.translate(-(this.md.xmin + this.md.xmax) / 2.0, -(this.md.ymin + this.md.ymax) / 2.0, -(this.md.zmin + this.md.zmax) / 2.0);
            this.md.mat.mult(this.amat);
            this.md.mat.scale(this.xfac, -this.xfac, 16.0 * this.xfac / (double)this.getSize().width);
            this.md.mat.translate(this.getSize().width / 2, this.getSize().height / 2, 8.0);
            this.md.transformed = false;
            this.md.paint(graphics2D);
            this.setPainted();
        } else if (this.message != null) {
            graphics2D.drawString("Error in model:", 3, 20);
            graphics2D.drawString(this.message, 10, 40);
        }
    }

    private synchronized void setPainted() {
        this.painted = true;
        this.notifyAll();
    }
}

