/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Vector;

public class PageableText
implements Pageable,
Printable {
    public static String FONTFAMILY = "Monospaced";
    public static int FONTSIZE = 10;
    public static int FONTSTYLE = 0;
    public static float LINESPACEFACTOR = 1.1f;
    PageFormat format;
    Vector lines;
    Font font;
    int linespacing;
    int linesPerPage;
    int numPages;
    int baseline = -1;

    public PageableText(File file, PageFormat pageFormat) throws IOException {
        this(new FileReader(file), pageFormat);
    }

    public PageableText(Reader reader, PageFormat pageFormat) throws IOException {
        String string;
        this.format = pageFormat;
        BufferedReader bufferedReader = new BufferedReader(reader);
        this.lines = new Vector();
        while ((string = bufferedReader.readLine()) != null) {
            this.lines.addElement(string);
        }
        this.font = new Font(FONTFAMILY, FONTSTYLE, FONTSIZE);
        this.linespacing = (int)((float)FONTSIZE * LINESPACEFACTOR);
        this.linesPerPage = (int)Math.floor(pageFormat.getImageableHeight() / (double)this.linespacing);
        this.numPages = (this.lines.size() - 1) / this.linesPerPage + 1;
    }

    @Override
    public int getNumberOfPages() {
        return this.numPages;
    }

    @Override
    public PageFormat getPageFormat(int n) {
        return this.format;
    }

    @Override
    public Printable getPrintable(int n) {
        return this;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        if (n < 0 | n >= this.numPages) {
            return 1;
        }
        if (this.baseline == -1) {
            FontMetrics fontMetrics = graphics.getFontMetrics(this.font);
            this.baseline = fontMetrics.getAscent();
        }
        graphics.setColor(Color.white);
        graphics.fillRect((int)pageFormat.getImageableX(), (int)pageFormat.getImageableY(), (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
        graphics.setFont(this.font);
        graphics.setColor(Color.black);
        int n2 = n * this.linesPerPage;
        int n3 = n2 + this.linesPerPage - 1;
        if (n3 >= this.lines.size()) {
            n3 = this.lines.size() - 1;
        }
        int n4 = (int)pageFormat.getImageableX();
        int n5 = (int)pageFormat.getImageableY() + this.baseline;
        for (int i = n2; i <= n3; ++i) {
            String string = (String)this.lines.elementAt(i);
            if (string.length() > 0) {
                graphics.drawString(string, n4, n5);
            }
            n5 += this.linespacing;
        }
        return 0;
    }
}

